/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeArrayIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.ChildEnumeration;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.TextImpl;

abstract class ParentNodeImpl
extends NodeImpl {
    protected Object children = null;
    protected int sequence;

    ParentNodeImpl() {
    }

    protected final long getSequenceNumber() {
        return this.sequence == -1 ? -1L : (long)this.sequence << 32;
    }

    public final boolean hasChildNodes() {
        return this.children != null;
    }

    public int getNumberOfChildren() {
        if (this.children == null) {
            return 0;
        }
        if (this.children instanceof NodeImpl) {
            return 1;
        }
        return ((NodeInfo[])this.children).length;
    }

    protected final AxisIterator enumerateChildren(NodeTest test) {
        if (this.children == null) {
            return EmptyIterator.getInstance();
        }
        if (this.children instanceof NodeImpl) {
            NodeImpl child = (NodeImpl)this.children;
            if (test == null || test instanceof AnyNodeTest) {
                return SingleNodeIterator.makeIterator(child);
            }
            return Navigator.filteredSingleton(child, test);
        }
        if (test == null || test instanceof AnyNodeTest) {
            return new NodeArrayIterator((NodeImpl[])this.children);
        }
        return new ChildEnumeration(this, test);
    }

    public final NodeInfo getFirstChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        return ((NodeImpl[])this.children)[0];
    }

    public final NodeInfo getLastChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        NodeImpl[] n = (NodeImpl[])this.children;
        return n[n.length - 1];
    }

    protected final NodeImpl getNthChild(int n) {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return n == 0 ? (NodeImpl)this.children : null;
        }
        NodeImpl[] nodes = (NodeImpl[])this.children;
        if (n < 0 || n >= nodes.length) {
            return null;
        }
        return nodes[n];
    }

    protected void removeChild(NodeImpl child) {
        if (this.children == null) {
            return;
        }
        if (this.children == child) {
            this.children = null;
            return;
        }
        NodeImpl[] nodes = (NodeImpl[])this.children;
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] != child) continue;
            if (nodes.length == 2) {
                this.children = nodes[1 - i];
                break;
            }
            NodeImpl[] n2 = new NodeImpl[nodes.length - 1];
            if (i > 0) {
                System.arraycopy(nodes, 0, n2, 0, i);
            }
            if (i < nodes.length - 1) {
                System.arraycopy(nodes, i + 1, n2, i, nodes.length - i - 1);
            }
            this.children = this.cleanUpChildren(n2);
            break;
        }
    }

    private NodeImpl[] cleanUpChildren(NodeImpl[] children) {
        boolean prevText = false;
        int j = 0;
        NodeImpl[] c2 = new NodeImpl[children.length];
        for (int i = 0; i < children.length; ++i) {
            NodeImpl node = children[i];
            if (node instanceof TextImpl) {
                if (prevText) {
                    TextImpl prev = (TextImpl)c2[j - 1];
                    prev.replaceStringValue(prev.getStringValue() + node.getStringValue());
                    continue;
                }
                if (node.getStringValue().length() <= 0) continue;
                prevText = true;
                node.index = j;
                c2[j++] = node;
                continue;
            }
            node.index = j;
            c2[j++] = node;
            prevText = false;
        }
        if (j == c2.length) {
            return c2;
        }
        NodeImpl[] c3 = new NodeImpl[j];
        System.arraycopy(c2, 0, c3, 0, j);
        return c3;
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer sb = null;
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = next.getNextInDocument(this)) {
            if (!(next instanceof TextImpl)) continue;
            if (sb == null) {
                sb = new FastStringBuffer(1024);
            }
            sb.append(next.getStringValueCS());
        }
        if (sb == null) {
            return "";
        }
        return sb.condense();
    }

    protected void useChildrenArray(NodeImpl[] array) {
        this.children = array;
    }

    public synchronized void addChild(NodeImpl node, int index) {
        NodeImpl[] c2;
        if (this.children == null) {
            c2 = new NodeImpl[10];
        } else if (this.children instanceof NodeImpl) {
            c2 = new NodeImpl[10];
            c2[0] = (NodeImpl)this.children;
        } else {
            c2 = (NodeImpl[])this.children;
        }
        if (index >= c2.length) {
            NodeImpl[] kids = new NodeImpl[c2.length * 2];
            System.arraycopy(c2, 0, kids, 0, c2.length);
            c2 = kids;
        }
        c2[index] = node;
        node.parent = this;
        node.index = index;
        this.children = c2;
    }

    public void insertChildren(NodeInfo[] source, boolean atStart, boolean inherit) {
        if (atStart) {
            this.insertChildrenAt(source, 0, inherit);
        } else {
            this.insertChildrenAt(source, this.getNumberOfChildren(), inherit);
        }
    }

    protected synchronized void insertChildrenAt(NodeInfo[] source, int index, boolean inherit) {
        NodeImpl[] n2;
        if (source.length == 0) {
            return;
        }
        for (int i = 0; i < source.length; ++i) {
            NodeImpl child = (NodeImpl)source[i];
            child.parent = this;
            if (!(child instanceof ElementImpl)) continue;
            ((ElementImpl)child).fixupInsertedNamespaces(inherit);
        }
        if (this.children == null) {
            if (source.length == 1) {
                this.children = source[0];
            } else {
                NodeImpl[] n22 = new NodeImpl[source.length];
                System.arraycopy(source, 0, n22, 0, source.length);
                this.children = n22;
            }
        } else if (this.children instanceof NodeImpl) {
            int adjacent;
            int n = adjacent = index == 0 ? 0 : source.length - 1;
            if (this.children instanceof TextImpl && source[adjacent] instanceof TextImpl) {
                if (index == 0) {
                    ((TextImpl)source[adjacent]).replaceStringValue(source[adjacent].getStringValue() + ((TextImpl)this.children).getStringValue());
                } else {
                    ((TextImpl)source[adjacent]).replaceStringValue(((TextImpl)this.children).getStringValue() + source[adjacent].getStringValue());
                }
                n2 = new NodeImpl[source.length];
                System.arraycopy(source, 0, n2, 0, source.length);
                this.children = n2;
            } else {
                n2 = new NodeImpl[source.length + 1];
                if (index == 0) {
                    System.arraycopy(source, 0, n2, 0, source.length);
                    n2[source.length] = (NodeImpl)this.children;
                } else {
                    n2[0] = (NodeImpl)this.children;
                    System.arraycopy(source, 0, n2, 1, source.length);
                }
                this.children = this.cleanUpChildren(n2);
            }
        } else {
            NodeImpl[] n0 = (NodeImpl[])this.children;
            n2 = new NodeImpl[n0.length + source.length];
            System.arraycopy(n0, 0, n2, 0, index);
            System.arraycopy(source, 0, n2, index, source.length);
            System.arraycopy(n0, index, n2, index + source.length, n0.length - index);
            this.children = this.cleanUpChildren(n2);
        }
    }

    protected synchronized void replaceChildrenAt(NodeInfo[] source, int index, boolean inherit) {
        if (this.children == null) {
            return;
        }
        block4: for (int i = 0; i < source.length; ++i) {
            NodeImpl child = (NodeImpl)source[i];
            child.parent = this;
            int kind = child.getNodeKind();
            switch (kind) {
                case 1: {
                    ((ElementImpl)child).fixupInsertedNamespaces(inherit);
                    continue block4;
                }
                case 3: 
                case 7: 
                case 8: {
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Replacement child node is not an element, text, comment, or PI");
                }
            }
        }
        if (this.children instanceof NodeImpl) {
            if (source.length == 0) {
                this.children = null;
            } else if (source.length == 1) {
                this.children = source[0];
            } else {
                NodeImpl[] n2 = new NodeImpl[source.length];
                System.arraycopy(source, 0, n2, 0, source.length);
                this.children = this.cleanUpChildren(n2);
            }
        } else {
            NodeImpl[] n0 = (NodeImpl[])this.children;
            NodeImpl[] n2 = new NodeImpl[n0.length + source.length - 1];
            System.arraycopy(n0, 0, n2, 0, index);
            System.arraycopy(source, 0, n2, index, source.length);
            System.arraycopy(n0, index + 1, n2, index + source.length, n0.length - index - 1);
            this.children = this.cleanUpChildren(n2);
        }
    }

    public synchronized void compact(int size) {
        if (size == 0) {
            this.children = null;
        } else if (size == 1) {
            if (this.children instanceof NodeImpl[]) {
                this.children = ((NodeImpl[])this.children)[0];
            }
        } else {
            NodeImpl[] kids = new NodeImpl[size];
            System.arraycopy(this.children, 0, kids, 0, size);
            this.children = kids;
        }
    }
}

