/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AncestorEnumeration;
import net.sf.saxon.tree.AttributeEnumeration;
import net.sf.saxon.tree.DescendantEnumeration;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.FollowingEnumeration;
import net.sf.saxon.tree.FollowingSiblingEnumeration;
import net.sf.saxon.tree.ParentNodeImpl;
import net.sf.saxon.tree.PrecedingEnumeration;
import net.sf.saxon.tree.PrecedingOrAncestorEnumeration;
import net.sf.saxon.tree.PrecedingSiblingEnumeration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public abstract class NodeImpl
implements MutableNodeInfo,
FingerprintedNode,
SiblingCountingNode,
SourceLocator {
    protected ParentNodeImpl parent;
    protected int index;
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    public int getTypeAnnotation() {
        return 630;
    }

    public int getColumnNumber() {
        if (this.parent == null) {
            return -1;
        }
        return this.parent.getColumnNumber();
    }

    public String getPublicId() {
        return null;
    }

    public int getDocumentNumber() {
        return this.getPhysicalRoot().getDocumentNumber();
    }

    public int getSiblingPosition() {
        return this.index;
    }

    public SequenceIterator getTypedValue() throws XPathException {
        int annotation = this.getTypeAnnotation();
        if ((annotation & 0x40000000) != 0) {
            annotation = 631;
        }
        if ((annotation &= 0xFFFFF) == -1 || annotation == 631 || annotation == 630) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValueCS()));
        }
        SchemaType stype = this.getConfiguration().getSchemaType(annotation);
        if (stype == null) {
            String typeName;
            try {
                typeName = this.getNamePool().getDisplayName(annotation);
            }
            catch (Exception err) {
                typeName = annotation + "";
            }
            throw new XPathException("Unknown type annotation " + Err.wrap(typeName) + " in document instance");
        }
        return stype.getTypedValue(this);
    }

    public Value atomize() throws XPathException {
        int annotation = this.getTypeAnnotation();
        if ((annotation & 0x40000000) != 0) {
            annotation = 631;
        }
        if (annotation == -1 || annotation == 631 || annotation == 630) {
            return new UntypedAtomicValue(this.getStringValueCS());
        }
        SchemaType stype = this.getConfiguration().getSchemaType(annotation);
        if (stype == null) {
            String typeName = this.getNamePool().getDisplayName(annotation);
            throw new XPathException("Unknown type annotation " + Err.wrap(typeName) + " in document instance");
        }
        return stype.atomize(this);
    }

    public void setSystemId(String uri) {
        this.getParent().setSystemId(uri);
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        return this == other;
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        FastStringBuffer buff = new FastStringBuffer(20);
        this.generateId(buff);
        return buff.toString().hashCode();
    }

    public int getNameCode() {
        return -1;
    }

    public int getFingerprint() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return -1;
        }
        return nameCode & 0xFFFFF;
    }

    public void generateId(FastStringBuffer buffer) {
        long seq = this.getSequenceNumber();
        if (seq == -1L) {
            this.getPhysicalRoot().generateId(buffer);
            buffer.append(NODE_LETTER[this.getNodeKind()]);
            buffer.append(Long.toString(seq));
        } else {
            this.parent.generateId(buffer);
            buffer.append(NODE_LETTER[this.getNodeKind()]);
            buffer.append(Integer.toString(this.index));
        }
    }

    public String getSystemId() {
        return this.parent.getSystemId();
    }

    public String getBaseURI() {
        return this.parent.getBaseURI();
    }

    protected long getSequenceNumber() {
        NodeImpl prev = this;
        int i = 0;
        while (true) {
            if (prev instanceof ParentNodeImpl) {
                long prevseq = prev.getSequenceNumber();
                return prevseq == -1L ? prevseq : prevseq + 65536L + (long)i;
            }
            prev = prev.getPreviousInDocument();
            ++i;
        }
    }

    public final int compareOrder(NodeInfo other) {
        if (other instanceof NamespaceIterator.NamespaceNodeImpl) {
            return 0 - other.compareOrder(this);
        }
        long a2 = this.getSequenceNumber();
        long b2 = ((NodeImpl)other).getSequenceNumber();
        if (a2 == -1L || b2 == -1L) {
            return Navigator.compareOrder(this, (NodeImpl)other);
        }
        if (a2 < b2) {
            return -1;
        }
        if (a2 > b2) {
            return 1;
        }
        return 0;
    }

    public Configuration getConfiguration() {
        return this.getPhysicalRoot().getConfiguration();
    }

    public NamePool getNamePool() {
        return this.getPhysicalRoot().getNamePool();
    }

    public String getPrefix() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        if (NamePool.getPrefixIndex(nameCode) == 0) {
            return "";
        }
        return this.getNamePool().getPrefix(nameCode);
    }

    public String getURI() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        return this.getNamePool().getURI(nameCode);
    }

    public String getDisplayName() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        return this.getNamePool().getDisplayName(nameCode);
    }

    public String getLocalPart() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        return this.getNamePool().getLocalName(nameCode);
    }

    public int getLineNumber() {
        return this.parent.getLineNumber();
    }

    public final NodeInfo getParent() {
        if (this.parent instanceof DocumentImpl && ((DocumentImpl)this.parent).isImaginary()) {
            return null;
        }
        return this.parent;
    }

    public NodeInfo getPreviousSibling() {
        return this.parent.getNthChild(this.index - 1);
    }

    public NodeInfo getNextSibling() {
        return this.parent.getNthChild(this.index + 1);
    }

    public NodeInfo getFirstChild() {
        return null;
    }

    public NodeInfo getLastChild() {
        return null;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        if (axisNumber == 3) {
            if (this instanceof ParentNodeImpl) {
                return ((ParentNodeImpl)this).enumerateChildren(null);
            }
            return EmptyIterator.getInstance();
        }
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: {
                return new AncestorEnumeration(this, nodeTest, false);
            }
            case 1: {
                return new AncestorEnumeration(this, nodeTest, true);
            }
            case 2: {
                if (this.getNodeKind() != 1) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeEnumeration(this, nodeTest);
            }
            case 3: {
                if (this instanceof ParentNodeImpl) {
                    return ((ParentNodeImpl)this).enumerateChildren(nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.getNodeKind() == 9 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
                    return ((DocumentImpl)this).getAllElements(nodeTest.getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this, nodeTest, false);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new DescendantEnumeration(this, nodeTest, true);
            }
            case 6: {
                return new FollowingEnumeration(this, nodeTest);
            }
            case 7: {
                return new FollowingSiblingEnumeration(this, nodeTest);
            }
            case 8: {
                if (this.getNodeKind() != 1) {
                    return EmptyIterator.getInstance();
                }
                return NamespaceIterator.makeIterator(this, nodeTest);
            }
            case 9: {
                NodeInfo parent = this.getParent();
                if (parent == null) {
                    return EmptyIterator.getInstance();
                }
                return Navigator.filteredSingleton(parent, nodeTest);
            }
            case 10: {
                return new PrecedingEnumeration(this, nodeTest);
            }
            case 11: {
                return new PrecedingSiblingEnumeration(this, nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new PrecedingOrAncestorEnumeration(this, nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public String getAttributeValue(int fingerprint) {
        return null;
    }

    public NodeInfo getRoot() {
        return this.getParent().getRoot();
    }

    public DocumentInfo getDocumentRoot() {
        return this.getParent().getDocumentRoot();
    }

    public DocumentImpl getPhysicalRoot() {
        ParentNodeImpl up = this.parent;
        while (up != null && !(up instanceof DocumentImpl)) {
            up = up.parent;
        }
        return (DocumentImpl)up;
    }

    public NodeImpl getNextInDocument(NodeImpl anchor) {
        NodeImpl next = (NodeImpl)this.getFirstChild();
        if (next != null) {
            return next;
        }
        if (this == anchor) {
            return null;
        }
        next = (NodeImpl)this.getNextSibling();
        if (next != null) {
            return next;
        }
        NodeImpl parent = this;
        do {
            if ((parent = (NodeImpl)parent.getParent()) == null) {
                return null;
            }
            if (parent != anchor) continue;
            return null;
        } while ((next = (NodeImpl)parent.getNextSibling()) == null);
        return next;
    }

    public NodeImpl getPreviousInDocument() {
        NodeImpl prev = (NodeImpl)this.getPreviousSibling();
        if (prev != null) {
            return prev.getLastDescendantOrSelf();
        }
        return (NodeImpl)this.getParent();
    }

    private NodeImpl getLastDescendantOrSelf() {
        NodeImpl last = (NodeImpl)this.getLastChild();
        if (last == null) {
            return this;
        }
        return last.getLastDescendantOrSelf();
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return null;
    }

    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    public boolean isId() {
        return false;
    }

    public boolean isIdref() {
        return false;
    }

    public boolean isNilled() {
        return false;
    }

    public void setTypeAnnotation(int typeCode) {
    }

    public void delete() {
        if (this.parent != null) {
            this.parent.removeChild(this);
            this.parent = null;
        }
    }

    public void removeAttribute(int nameCode) {
    }

    public void putAttribute(int nameCode, int typeCode, CharSequence value, int properties) {
    }

    public void rename(int newNameCode) {
    }

    public void addNamespace(int nscode, boolean inherit) {
    }

    public void replace(NodeInfo[] replacement, boolean inherit) {
        this.parent.replaceChildrenAt(replacement, this.index, inherit);
    }

    public void insertChildren(NodeInfo[] source, boolean atStart, boolean inherit) {
        throw new UnsupportedOperationException("insertChildren() can only be applied to a parent node");
    }

    public void insertSiblings(NodeInfo[] source, boolean before, boolean inherit) {
        if (this.parent == null) {
            throw new IllegalStateException("Cannot add siblings if there is no parent");
        }
        this.parent.insertChildrenAt(source, before ? this.index : this.index + 1, inherit);
    }

    public void removeTypeAnnotation() {
    }

    public Builder newBuilder() {
        return this.getPhysicalRoot().newBuilder();
    }
}

