/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Version;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.value.Whitespace;

public abstract class AbstractTraceListener
implements TraceListener {
    private int indent = 0;
    private PrintStream out = System.err;
    private static StringBuffer spaceBuffer = new StringBuffer("                ");

    public void open() {
        this.out.println("<trace saxon-version=\"" + Version.getProductVersion() + "\" " + this.getOpeningAttributes() + '>');
        ++this.indent;
    }

    protected abstract String getOpeningAttributes();

    public void close() {
        --this.indent;
        this.out.println("</trace>");
    }

    public void enter(InstructionInfo info, XPathContext context) {
        NamePool pool = context.getNamePool();
        int infotype = info.getConstructType();
        StructuredQName qName = info.getObjectName();
        String tag = this.tag(infotype);
        if (tag == null) {
            return;
        }
        String file = ExpressionLocation.truncateURI(info.getSystemId());
        String msg = AbstractTraceListener.spaces(this.indent) + '<' + tag;
        String name = (String)info.getProperty("name");
        if (name != null) {
            msg = msg + " name=\"" + this.escape(name) + '\"';
        } else if (qName != null) {
            msg = msg + " name=\"" + this.escape(qName.getDisplayName()) + '\"';
        }
        Iterator props = info.getProperties();
        while (props.hasNext()) {
            int rcurly;
            String prop = (String)props.next();
            Object val = info.getProperty(prop);
            if (prop.startsWith("{") && (rcurly = prop.indexOf(125)) > 0) {
                prop = prop.substring(rcurly + 1);
            }
            if (val == null || prop.equals("name") || prop.equals("expression")) continue;
            msg = msg + ' ' + prop + "=\"" + this.escape(val.toString()) + '\"';
        }
        msg = msg + " line=\"" + info.getLineNumber() + '\"';
        int col = info.getColumnNumber();
        if (col >= 0) {
            msg = msg + " column=\"" + info.getColumnNumber() + '\"';
        }
        msg = msg + " module=\"" + this.escape(file) + "\">";
        this.out.println(msg);
        ++this.indent;
    }

    public String escape(String in) {
        if (in == null) {
            return "";
        }
        CharSequence collapsed = Whitespace.collapseWhitespace(in);
        StringBuffer sb = new StringBuffer(collapsed.length() + 10);
        for (int i = 0; i < collapsed.length(); ++i) {
            char c2 = collapsed.charAt(i);
            if (c2 == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c2 == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c2 == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c2 == '\"') {
                sb.append("&#34;");
                continue;
            }
            if (c2 == '\n') {
                sb.append("&#xA;");
                continue;
            }
            if (c2 == '\r') {
                sb.append("&#xD;");
                continue;
            }
            if (c2 == '\t') {
                sb.append("&#x9;");
                continue;
            }
            sb.append(c2);
        }
        return sb.toString();
    }

    public void leave(InstructionInfo info) {
        int infotype = info.getConstructType();
        String tag = this.tag(infotype);
        if (tag == null) {
            return;
        }
        --this.indent;
        this.out.println(AbstractTraceListener.spaces(this.indent) + "</" + tag + '>');
    }

    protected abstract String tag(int var1);

    public void startCurrentItem(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo curr = (NodeInfo)item;
            this.out.println(AbstractTraceListener.spaces(this.indent) + "<source node=\"" + Navigator.getPath(curr) + "\" line=\"" + curr.getLineNumber() + "\" file=\"" + ExpressionLocation.truncateURI(curr.getSystemId()) + "\">");
        }
        ++this.indent;
    }

    public void endCurrentItem(Item item) {
        --this.indent;
        if (item instanceof NodeInfo) {
            NodeInfo curr = (NodeInfo)item;
            this.out.println(AbstractTraceListener.spaces(this.indent) + "</source><!-- " + Navigator.getPath(curr) + " -->");
        }
    }

    private static String spaces(int n) {
        while (spaceBuffer.length() < n) {
            spaceBuffer.append(spaceBuffer);
        }
        return spaceBuffer.substring(0, n);
    }

    public void setOutputDestination(PrintStream stream) {
        this.out = stream;
    }

    public PrintStream getOutputDestination() {
        return this.out;
    }
}

