/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeListIterator;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;

public final class TinyDocumentImpl
extends TinyParentNodeImpl
implements DocumentInfo {
    private HashMap idTable = null;
    private IntHashMap elementList = null;
    private HashMap entityTable = null;
    private String baseURI = null;

    public TinyDocumentImpl(TinyTree tree) {
        this.tree = tree;
        this.nodeNr = tree.numberOfNodes;
    }

    public TinyTree getTree() {
        return this.tree;
    }

    public void setConfiguration(Configuration config) {
        if (config != this.tree.getConfiguration()) {
            throw new IllegalArgumentException("Configuration of document differs from that of the supporting TinyTree");
        }
    }

    public Configuration getConfiguration() {
        return this.tree.getConfiguration();
    }

    public void setSystemId(String uri) {
        this.tree.setSystemId(this.nodeNr, uri);
    }

    public String getSystemId() {
        return this.tree.getSystemId(this.nodeNr);
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    public String getBaseURI() {
        if (this.baseURI != null) {
            return this.baseURI;
        }
        return this.getSystemId();
    }

    public int getLineNumber() {
        return 0;
    }

    public final int getNodeKind() {
        return 9;
    }

    public NodeInfo getParent() {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return this;
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append('d');
        buffer.append(Integer.toString(this.getDocumentNumber()));
    }

    AxisIterator getAllElements(int fingerprint) {
        List list;
        if (this.elementList == null) {
            this.elementList = new IntHashMap(20);
        }
        if ((list = (List)this.elementList.get(fingerprint)) == null) {
            list = this.getElementList(fingerprint);
            this.elementList.put(fingerprint, list);
        }
        return new NodeListIterator(list);
    }

    List getElementList(int fingerprint) {
        int size = this.tree.getNumberOfNodes() / 20;
        if (size > 100) {
            size = 100;
        }
        if (size < 20) {
            size = 20;
        }
        ArrayList<TinyNodeImpl> list = new ArrayList<TinyNodeImpl>(size);
        int i = this.nodeNr + 1;
        try {
            while (this.tree.depth[i] != 0) {
                if (this.tree.nodeKind[i] == 1 && (this.tree.nameCode[i] & 0xFFFFF) == fingerprint) {
                    list.add(this.tree.getNode(i));
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            return list;
        }
        return list;
    }

    void registerID(NodeInfo e2, String id) {
        NodeInfo old;
        if (this.idTable == null) {
            this.idTable = new HashMap(256);
        }
        if ((old = (NodeInfo)this.idTable.get(id)) == null) {
            this.idTable.put(id, e2);
        }
    }

    public NodeInfo selectID(String id) {
        if (this.idTable == null) {
            return null;
        }
        return (NodeInfo)this.idTable.get(id);
    }

    void setUnparsedEntity(String name, String uri, String publicId) {
        if (this.entityTable == null) {
            this.entityTable = new HashMap(20);
        }
        String[] ids = new String[]{uri, publicId};
        this.entityTable.put(name, ids);
    }

    public Iterator getUnparsedEntityNames() {
        if (this.entityTable == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.entityTable.keySet().iterator();
    }

    public String[] getUnparsedEntity(String name) {
        if (this.entityTable == null) {
            return null;
        }
        return (String[])this.entityTable.get(name);
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        NodeInfo n;
        out.startDocument(0);
        AxisIterator children = this.iterateAxis((byte)3);
        while ((n = (NodeInfo)children.next()) != null) {
            n.copy(out, whichNamespaces, copyAnnotations, locationId);
        }
        out.endDocument();
    }

    public void showSize() {
        this.tree.showSize();
    }
}

