/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.om.FastStringBuffer;

public final class LargeStringBuffer
implements CharSequence,
Serializable {
    private int minAllocation;
    private int maxAllocation;
    private List segments;
    private int[] startOffsets;
    private int length;

    public LargeStringBuffer() {
        this(4096, 65536);
    }

    public LargeStringBuffer(int minAllocation, int maxAllocation) {
        this.minAllocation = Math.min(minAllocation, maxAllocation);
        this.maxAllocation = maxAllocation;
        FastStringBuffer initial = new FastStringBuffer(minAllocation);
        this.segments = new ArrayList(4);
        this.segments.add(initial);
        this.startOffsets = new int[1];
        this.startOffsets[0] = 0;
        this.length = 0;
    }

    public void append(CharSequence data) {
        int increment = data.length();
        if (increment == 0) {
            return;
        }
        FastStringBuffer last = (FastStringBuffer)this.segments.get(this.segments.size() - 1);
        if (last.length() + increment <= this.maxAllocation) {
            last.append(data);
        } else {
            int[] s2 = new int[this.startOffsets.length + 1];
            System.arraycopy(this.startOffsets, 0, s2, 0, this.startOffsets.length);
            s2[this.startOffsets.length] = this.length;
            this.startOffsets = s2;
            last = new FastStringBuffer(Math.max(this.minAllocation, increment));
            this.segments.add(last);
            last.append(data);
        }
        this.length += increment;
    }

    public int length() {
        return this.length;
    }

    public char charAt(int index) {
        if (this.startOffsets.length == 1) {
            return ((FastStringBuffer)this.segments.get(0)).charAt(index);
        }
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(index + "");
        }
        int seg = Arrays.binarySearch(this.startOffsets, index);
        if (seg >= 0) {
            return ((FastStringBuffer)this.segments.get(seg)).charAt(0);
        }
        seg = -seg - 2;
        int offset = index - this.startOffsets[seg];
        return ((FastStringBuffer)this.segments.get(seg)).charAt(offset);
    }

    public CharSequence subSequence(int start, int end) {
        int offset1;
        int offset0;
        if (this.startOffsets.length == 1) {
            return ((FastStringBuffer)this.segments.get(0)).subSequence(start, end);
        }
        if (start < 0 || end < 0 || end > this.length || start > end) {
            throw new IndexOutOfBoundsException("[" + start + ',' + end + ']');
        }
        int seg0 = Arrays.binarySearch(this.startOffsets, start);
        if (seg0 >= 0) {
            offset0 = 0;
        } else {
            seg0 = -seg0 - 2;
            offset0 = start - this.startOffsets[seg0];
        }
        int seg1 = Arrays.binarySearch(this.startOffsets, end);
        if (seg1 >= 0) {
            offset1 = 0;
        } else {
            seg1 = -seg1 - 2;
            offset1 = end - this.startOffsets[seg1];
        }
        FastStringBuffer startSegment = (FastStringBuffer)this.segments.get(seg0);
        if (startSegment == null) {
            this.dumpDataStructure();
            throw new NullPointerException("startSegment: subSequence(" + start + ", " + end + ")");
        }
        if (seg0 == seg1) {
            return startSegment.subSequence(offset0, offset1);
        }
        FastStringBuffer sb = new FastStringBuffer(end - start);
        sb.append(startSegment.subSequence(offset0, startSegment.length()));
        for (int i = seg0 + 1; i < seg1; ++i) {
            sb.append((FastStringBuffer)this.segments.get(i));
        }
        if (offset1 > 0) {
            sb.append(((FastStringBuffer)this.segments.get(seg1)).subSequence(0, offset1));
        }
        return sb;
    }

    public String toString() {
        if (this.startOffsets.length == 1) {
            return this.segments.get(0).toString();
        }
        FastStringBuffer sb = new FastStringBuffer(this.length);
        for (int i = 0; i < this.segments.size(); ++i) {
            sb.append((FastStringBuffer)this.segments.get(i));
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        int h2 = 0;
        for (int s = 0; s < this.segments.size(); ++s) {
            FastStringBuffer sb = (FastStringBuffer)this.segments.get(s);
            for (int i = 0; i < sb.length(); ++i) {
                h2 = 31 * h2 + this.charAt(i);
            }
        }
        return h2;
    }

    public String substring(int start, int end) {
        return ((Object)this.subSequence(start, end)).toString();
    }

    public void write(Writer writer) throws IOException {
        for (int s = 0; s < this.segments.size(); ++s) {
            FastStringBuffer sb = (FastStringBuffer)this.segments.get(s);
            sb.write(writer);
        }
    }

    public void dumpDataStructure() {
        System.err.println("** Segments:");
        for (int s = 0; s < this.segments.size(); ++s) {
            System.err.println("   SEG " + s + " start offset " + this.startOffsets[s] + " length " + ((FastStringBuffer)this.segments.get(s)).length());
        }
    }
}

