/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import net.sf.saxon.om.FastStringBuffer;

public class CompressedWhitespace
implements CharSequence {
    private static char[] WHITE_CHARS = new char[]{'\t', '\n', '\r', ' '};
    private long value;
    private static byte[] ESCAPE_N = new byte[]{38, 35, 120, 65, 59};
    private static byte[] ESCAPE_R = new byte[]{38, 35, 120, 68, 59};
    private static byte[] ESCAPE_T = new byte[]{38, 35, 120, 57, 59};

    public CompressedWhitespace(long compressedValue) {
        this.value = compressedValue;
    }

    public static CharSequence compress(CharSequence in) {
        int inlen = in.length();
        if (inlen == 0) {
            return in;
        }
        int runlength = 1;
        int outlength = 0;
        for (int i = 0; i < inlen; ++i) {
            char c2 = in.charAt(i);
            if ("\t\n\r ".indexOf(c2) >= 0) {
                if (i == inlen - 1 || c2 != in.charAt(i + 1) || runlength == 63) {
                    runlength = 1;
                    if (++outlength <= 8) continue;
                    return in;
                }
                ++runlength;
                continue;
            }
            return in;
        }
        int ix = 0;
        runlength = 1;
        int[] out = new int[outlength];
        for (int i = 0; i < inlen; ++i) {
            char c3 = in.charAt(i);
            if (i == inlen - 1 || c3 != in.charAt(i + 1) || runlength == 63) {
                int code = "\t\n\r ".indexOf(c3);
                out[ix++] = code << 6 | runlength;
                runlength = 1;
                continue;
            }
            ++runlength;
        }
        long value = 0L;
        for (int i = 0; i < outlength; ++i) {
            value = value << 8 | (long)out[i];
        }
        return new CompressedWhitespace(value <<= 8 * (8 - outlength));
    }

    public FastStringBuffer uncompress(FastStringBuffer buffer) {
        if (buffer == null) {
            buffer = new FastStringBuffer(this.length());
        }
        CompressedWhitespace.uncompress(this.value, buffer);
        return buffer;
    }

    public static void uncompress(long value, FastStringBuffer buffer) {
        byte b2;
        for (int s = 56; s >= 0 && (b2 = (byte)(value >>> s & 0xFFL)) != 0; s -= 8) {
            char c2 = WHITE_CHARS[b2 >>> 6 & 3];
            int len = b2 & 0x3F;
            buffer.ensureCapacity(len);
            for (int j = 0; j < len; ++j) {
                buffer.append(c2);
            }
        }
    }

    public long getCompressedValue() {
        return this.value;
    }

    public int length() {
        int c2;
        int count = 0;
        long val = this.value;
        for (int s = 56; s >= 0 && (c2 = (int)(val >>> s & 0x3FL)) != 0; s -= 8) {
            count += c2;
        }
        return count;
    }

    public char charAt(int index) {
        byte b2;
        int count = 0;
        long val = this.value;
        for (int s = 56; s >= 0 && (b2 = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
            if ((count += b2 & 0x3F) <= index) continue;
            return WHITE_CHARS[b2 >>> 6 & 3];
        }
        throw new IndexOutOfBoundsException(index + "");
    }

    public CharSequence subSequence(int start, int end) {
        return this.uncompress(null).subSequence(start, end);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompressedWhitespace) {
            return this.value == ((CompressedWhitespace)obj).value;
        }
        return this.uncompress(null).equals(obj);
    }

    public int hashCode() {
        return this.uncompress(null).hashCode();
    }

    public String toString() {
        return this.uncompress(null).toString();
    }

    public void write(Writer writer) throws IOException {
        byte b2;
        long val = this.value;
        for (int s = 56; s >= 0 && (b2 = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
            char c2 = WHITE_CHARS[b2 >>> 6 & 3];
            int len = b2 & 0x3F;
            for (int j = 0; j < len; ++j) {
                writer.write(c2);
            }
        }
    }

    public void writeEscape(boolean[] specialChars, Writer writer) throws IOException {
        byte b2;
        long val = this.value;
        for (int s = 56; s >= 0 && (b2 = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
            char c2 = WHITE_CHARS[b2 >>> 6 & 3];
            int len = b2 & 0x3F;
            if (specialChars[c2]) {
                String e2 = "";
                if (c2 == '\n') {
                    e2 = "&#xA;";
                } else if (c2 == '\r') {
                    e2 = "&#xD;";
                } else if (c2 == '\t') {
                    e2 = "&#x9;";
                }
                for (int j = 0; j < len; ++j) {
                    writer.write(e2);
                }
                continue;
            }
            for (int j = 0; j < len; ++j) {
                writer.write(c2);
            }
        }
    }

    public void writeEscape(boolean[] specialChars, OutputStream stream) throws IOException {
        byte b2;
        long val = this.value;
        for (int s = 56; s >= 0 && (b2 = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
            char c2 = WHITE_CHARS[b2 >>> 6 & 3];
            int len = b2 & 0x3F;
            if (specialChars[c2]) {
                byte[] e2 = c2 == '\n' ? ESCAPE_N : (c2 == '\r' ? ESCAPE_R : ESCAPE_T);
                for (int j = 0; j < len; ++j) {
                    stream.write(e2);
                }
                continue;
            }
            for (int j = 0; j < len; ++j) {
                stream.write(c2);
            }
        }
    }
}

