/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ProcessingInstruction;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.XSLStringConstructor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLProcessingInstruction
extends XSLStringConstructor {
    Expression name;

    public void prepareAttributes() throws XPathException {
        String nameAtt = null;
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a2 = 0; a2 < atts.getLength(); ++a2) {
            int nc = atts.getNameCode(a2);
            String f2 = this.getNamePool().getClarkName(nc);
            if (f2 == "name") {
                nameAtt = Whitespace.trim(atts.getValue(a2));
                continue;
            }
            if (f2 == "select") {
                selectAtt = Whitespace.trim(atts.getValue(a2));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else {
            this.name = this.makeAttributeValueTemplate(nameAtt);
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate() throws XPathException {
        this.name = this.typeCheck("name", this.name);
        this.select = this.typeCheck("select", this.select);
        super.validate();
    }

    protected String getErrorCodeForSelectPlusContent() {
        return "XTSE0880";
    }

    public Expression compile(Executable exec) throws XPathException {
        ProcessingInstruction inst = new ProcessingInstruction(this.name);
        this.compileContent(exec, inst, new StringLiteral(StringValue.SINGLE_SPACE));
        return inst;
    }
}

