/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Whitespace;

public class XSLPerformSort
extends StyleElement {
    Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.select == null) {
            return this.getCommonChildItemType();
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return this.select.getItemType(th);
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLSort;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        for (int a2 = 0; a2 < atts.getLength(); ++a2) {
            int nc = atts.getNameCode(a2);
            String f2 = this.getNamePool().getClarkName(nc);
            if (f2.equals("select")) {
                selectAtt = atts.getValue(a2);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate() throws XPathException {
        this.checkSortComesFirst(true);
        if (this.select != null) {
            NodeInfo child;
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((child = (NodeInfo)kids.next()) != null) {
                if (child instanceof XSLSort || child instanceof XSLFallback) continue;
                if (child.getNodeKind() == 3 && !Whitespace.isWhite(child.getStringValueCS())) {
                    this.compileError("Within xsl:perform-sort, significant text must not appear if there is a select attribute", "XTSE1040");
                    continue;
                }
                ((StyleElement)child).compileError("Within xsl:perform-sort, child instructions are not allowed if there is a select attribute", "XTSE1040");
            }
        }
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Executable exec) throws XPathException {
        SortKeyDefinition[] sortKeys = this.makeSortKeys();
        if (this.select != null) {
            return new SortExpression(this.select, sortKeys);
        }
        Expression body = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        if (body == null) {
            body = Literal.makeEmptySequence();
        }
        try {
            return new SortExpression(this.makeExpressionVisitor().simplify(body), sortKeys);
        }
        catch (XPathException e2) {
            this.compileError(e2);
            return null;
        }
    }
}

