/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Namespace;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLStringConstructor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLNamespace
extends XSLStringConstructor {
    Expression name;

    public void prepareAttributes() throws XPathException {
        String nameAtt = null;
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a2 = 0; a2 < atts.getLength(); ++a2) {
            int nc = atts.getNameCode(a2);
            String f2 = this.getNamePool().getClarkName(nc);
            if (f2 == "name") {
                nameAtt = Whitespace.trim(atts.getValue(a2));
                continue;
            }
            if (f2 == "select") {
                selectAtt = Whitespace.trim(atts.getValue(a2));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else {
            this.name = this.makeAttributeValueTemplate(nameAtt);
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate() throws XPathException {
        NodeInfo child;
        this.name = this.typeCheck("name", this.name);
        this.select = this.typeCheck("select", this.select);
        int countChildren = 0;
        NodeInfo firstChild = null;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLFallback) continue;
            if (this.select != null) {
                String errorCode = this.getErrorCodeForSelectPlusContent();
                this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", errorCode);
            }
            ++countChildren;
            if (firstChild != null) break;
            firstChild = child;
        }
        if (this.select == null) {
            if (countChildren == 0) {
                this.select = new StringLiteral(StringValue.EMPTY_STRING);
            } else if (countChildren == 1 && firstChild.getNodeKind() == 3) {
                this.select = new StringLiteral(firstChild.getStringValueCS());
            }
        }
    }

    protected String getErrorCodeForSelectPlusContent() {
        return "XTSE0910";
    }

    public Expression compile(Executable exec) throws XPathException {
        Namespace inst = new Namespace(this.name);
        this.compileContent(exec, inst, new StringLiteral(StringValue.SINGLE_SPACE));
        return inst;
    }
}

