/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Message;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public final class XSLMessage
extends StyleElement {
    private Expression terminate = null;
    private Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String t;
        String terminateAtt = null;
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a2 = 0; a2 < atts.getLength(); ++a2) {
            int nc = atts.getNameCode(a2);
            String f2 = this.getNamePool().getClarkName(nc);
            if (f2 == "terminate") {
                terminateAtt = Whitespace.trim(atts.getValue(a2));
                continue;
            }
            if (f2 == "select") {
                selectAtt = atts.getValue(a2);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
        if (terminateAtt == null) {
            terminateAtt = "no";
        }
        this.terminate = this.makeAttributeValueTemplate(terminateAtt);
        if (this.terminate instanceof StringLiteral && !(t = ((StringLiteral)this.terminate).getStringValue()).equals("yes") && !t.equals("no")) {
            this.compileError("terminate must be 'yes' or 'no'", "XTSE0020");
        }
    }

    public void validate() throws XPathException {
        this.select = this.typeCheck("select", this.select);
        this.terminate = this.typeCheck("terminate", this.terminate);
    }

    public Expression compile(Executable exec) throws XPathException {
        Expression b2 = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        if (b2 != null) {
            if (this.select == null) {
                this.select = b2;
            } else {
                this.select = Block.makeBlock(this.select, b2);
                this.select.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (this.select == null) {
            this.select = new StringLiteral("xsl:message (no content)");
        }
        Message inst = new Message(this.select, this.terminate);
        return inst;
    }
}

