/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ForEachGroup;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public final class XSLForEachGroup
extends StyleElement {
    private Expression select = null;
    private Expression groupBy = null;
    private Expression groupAdjacent = null;
    private Pattern starting = null;
    private Pattern ending = null;
    private Expression collationName;

    public boolean isInstruction() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLSort;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String groupByAtt = null;
        String groupAdjacentAtt = null;
        String startingAtt = null;
        String endingAtt = null;
        String collationAtt = null;
        for (int a2 = 0; a2 < atts.getLength(); ++a2) {
            int nc = atts.getNameCode(a2);
            String f2 = this.getNamePool().getClarkName(nc);
            if (f2.equals("select")) {
                selectAtt = atts.getValue(a2);
                continue;
            }
            if (f2.equals("group-by")) {
                groupByAtt = atts.getValue(a2);
                continue;
            }
            if (f2.equals("group-adjacent")) {
                groupAdjacentAtt = atts.getValue(a2);
                continue;
            }
            if (f2.equals("group-starting-with")) {
                startingAtt = atts.getValue(a2);
                continue;
            }
            if (f2.equals("group-ending-with")) {
                endingAtt = atts.getValue(a2);
                continue;
            }
            if (f2.equals("collation")) {
                collationAtt = Whitespace.trim(atts.getValue(a2));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
            this.select = new Literal(EmptySequence.getInstance());
        } else {
            this.select = this.makeExpression(selectAtt);
        }
        int c2 = (groupByAtt == null ? 0 : 1) + (groupAdjacentAtt == null ? 0 : 1) + (startingAtt == null ? 0 : 1) + (endingAtt == null ? 0 : 1);
        if (c2 != 1) {
            this.compileError("Exactly one of the attributes group-by, group-adjacent, group-starting-with, and group-ending-with must be specified", "XTSE1080");
        }
        if (groupByAtt != null) {
            this.groupBy = this.makeExpression(groupByAtt);
        }
        if (groupAdjacentAtt != null) {
            this.groupAdjacent = this.makeExpression(groupAdjacentAtt);
        }
        if (startingAtt != null) {
            this.starting = this.makePattern(startingAtt);
        }
        if (endingAtt != null) {
            this.ending = this.makePattern(endingAtt);
        }
        if (collationAtt != null) {
            if (this.groupBy == null && this.groupAdjacent == null) {
                this.compileError("A collation may be specified only if group-by or group-adjacent is specified", "XTSE1090");
            } else {
                this.collationName = this.makeAttributeValueTemplate(collationAtt);
                if (this.collationName instanceof StringLiteral) {
                    String collation = ((StringLiteral)this.collationName).getStringValue();
                    try {
                        URI collationURI = new URI(collation);
                        if (!collationURI.isAbsolute()) {
                            URI base = new URI(this.getBaseURI());
                            collationURI = base.resolve(collationURI);
                            this.collationName = new StringLiteral(collationURI.toString());
                        }
                    }
                    catch (URISyntaxException err) {
                        this.compileError("Collation name '" + this.collationName + "' is not a valid URI", "XTDE1110");
                        this.collationName = new StringLiteral("http://www.w3.org/2005/xpath-functions/collation/codepoint");
                    }
                }
            }
        } else {
            String defaultCollation = this.getDefaultCollationName();
            if (defaultCollation != null) {
                this.collationName = new StringLiteral(defaultCollation);
            }
        }
    }

    public void validate() throws XPathException {
        RoleLocator role;
        this.checkSortComesFirst(false);
        this.select = this.typeCheck("select", this.select);
        ExpressionLocation locator = new ExpressionLocation(this);
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        if (this.groupBy != null) {
            this.groupBy = this.typeCheck("group-by", this.groupBy);
            try {
                role = new RoleLocator(4, (Serializable)((Object)"xsl:for-each-group/group-by"), 0);
                this.groupBy = TypeChecker.staticTypeCheck(this.groupBy, SequenceType.ATOMIC_SEQUENCE, false, role, visitor);
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        } else if (this.groupAdjacent != null) {
            this.groupAdjacent = this.typeCheck("group-adjacent", this.groupAdjacent);
            try {
                role = new RoleLocator(4, (Serializable)((Object)"xsl:for-each-group/group-adjacent"), 0);
                role.setErrorCode("XTTE1100");
                this.groupAdjacent = TypeChecker.staticTypeCheck(this.groupAdjacent, SequenceType.SINGLE_ATOMIC, false, role, visitor);
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        }
        this.starting = this.typeCheck("starting", this.starting);
        this.ending = this.typeCheck("ending", this.ending);
        if (this.starting != null || this.ending != null) {
            try {
                role = new RoleLocator(4, (Serializable)((Object)"xsl:for-each-group/select"), 0);
                role.setErrorCode("XTTE1120");
                this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.NODE_SEQUENCE, false, role, visitor);
            }
            catch (XPathException err) {
                String prefix = this.starting != null ? "With group-starting-with attribute: " : "With group-ending-with attribute: ";
                this.compileError(prefix + err.getMessage(), err.getErrorCodeLocalPart());
            }
        }
        if (!this.hasChildNodes()) {
            this.compileWarning("An empty xsl:for-each-group instruction has no effect", "SXWN9009");
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        StringCollator collator = null;
        if (this.collationName instanceof StringLiteral) {
            String uri = ((StringLiteral)this.collationName).getStringValue();
            collator = this.getPrincipalStylesheet().findCollation(uri);
            if (collator == null) {
                this.compileError("The collation name '" + this.collationName + "' has not been defined", "XTDE1110");
            }
        }
        byte algorithm = 0;
        Expression key = null;
        if (this.groupBy != null) {
            algorithm = 0;
            key = this.groupBy;
        } else if (this.groupAdjacent != null) {
            algorithm = 1;
            key = this.groupAdjacent;
        } else if (this.starting != null) {
            algorithm = 2;
            key = new PatternSponsor(this.starting);
        } else if (this.ending != null) {
            algorithm = 3;
            key = new PatternSponsor(this.ending);
        }
        Expression action = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        if (action == null) {
            return new Literal(EmptySequence.getInstance());
        }
        try {
            return new ForEachGroup(this.select, this.makeExpressionVisitor().simplify(action), algorithm, key, collator, this.collationName, this.getBaseURI(), this.makeSortKeys());
        }
        catch (XPathException e2) {
            this.compileError(e2);
            return null;
        }
    }
}

