/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.ApplyImports;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XSLApplyImports
extends StyleElement {
    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a2 = 0; a2 < atts.getLength(); ++a2) {
            int nc = atts.getNameCode(a2);
            this.checkUnknownAttribute(nc);
        }
    }

    public void validate() throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLWithParam) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:apply-imports", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + child.getDisplayName() + " is not allowed within xsl:apply-imports", "XTSE0010");
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        ApplyImports inst = new ApplyImports(this.backwardsCompatibleModeIsEnabled());
        inst.setActualParameters(this.getWithParamInstructions(exec, false, inst), this.getWithParamInstructions(exec, true, inst));
        return inst;
    }
}

