/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.While;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;

public class SaxonWhile
extends StyleElement {
    private Expression test;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String testAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a2 = 0; a2 < atts.getLength(); ++a2) {
            int nc = atts.getNameCode(a2);
            String f2 = this.getNamePool().getClarkName(nc);
            if (f2 == "test") {
                testAtt = atts.getValue(a2);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (testAtt == null) {
            this.reportAbsence("test");
            return;
        }
        this.test = this.makeExpression(testAtt);
    }

    public void validate() throws XPathException {
        this.test = this.typeCheck("test", this.test);
    }

    public Expression compile(Executable exec) throws XPathException {
        Expression action = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        if (action == null) {
            action = Literal.makeEmptySequence();
        }
        While w = new While(this.test, action);
        return w;
    }
}

