/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class SaxonImportQuery
extends StyleElement {
    private String href;
    private String moduleURI;

    public void importModule() throws XPathException {
        this.prepareAttributes();
        this.loadLibraryModule();
    }

    public void prepareAttributes() throws XPathException {
        if (this.href != null || this.moduleURI != null) {
            return;
        }
        AttributeCollection atts = this.getAttributeList();
        for (int a2 = 0; a2 < atts.getLength(); ++a2) {
            int nc = atts.getNameCode(a2);
            String f2 = this.getNamePool().getClarkName(nc);
            if (f2.equals("href")) {
                this.href = Whitespace.trim(atts.getValue(a2));
                continue;
            }
            if (f2.equals("namespace")) {
                this.moduleURI = Whitespace.trim(atts.getValue(a2));
                continue;
            }
            this.checkUnknownAttribute(nc);
            this.moduleURI = "";
        }
        if (this.href == null && this.moduleURI == null) {
            this.compileError("At least one of href or namespace must be specified");
            this.moduleURI = "";
        }
    }

    public void validate() throws XPathException {
        this.checkEmpty();
        this.checkTopLevel(null);
    }

    private void loadLibraryModule() throws XPathException {
        if (this.href == null && this.moduleURI == null) {
            return;
        }
        try {
            XSLStylesheet top = this.getPrincipalStylesheet();
            QueryModule importedModule = this.loadModule();
            Iterator it = importedModule.getGlobalFunctionLibrary().getFunctionDefinitions();
            while (it.hasNext()) {
                XQueryFunction def = (XQueryFunction)it.next();
                if (!def.getFunctionName().getNamespaceURI().equals(this.moduleURI)) continue;
                top.declareXQueryFunction(def);
            }
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    private QueryModule loadModule() throws XPathException {
        StaticQueryContext sqc = new StaticQueryContext(this.getConfiguration());
        sqc.setExecutable(this.getExecutable());
        sqc.setBaseURI(this.getBaseURI());
        String mainModule = "import module namespace m = \"" + this.moduleURI + "\" at \"" + this.href + "\"; ()";
        XQueryExpression exp = sqc.compileQuery(mainModule);
        return exp.getStaticContext();
    }

    public Expression compile(Executable exec) throws XPathException {
        exec.setReasonUnableToCompile("Cannot compile a stylesheet that imports an XQuery library module");
        return null;
    }
}

