/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class SaxonEntityRef
extends StyleElement {
    String nameAttribute;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a2 = 0; a2 < atts.getLength(); ++a2) {
            int nc = atts.getNameCode(a2);
            String f2 = this.getNamePool().getClarkName(nc);
            if (f2 == "name") {
                this.nameAttribute = Whitespace.trim(atts.getValue(a2));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (this.nameAttribute == null) {
            this.reportAbsence("name");
        }
    }

    public void validate() throws XPathException {
        this.checkEmpty();
    }

    public Expression compile(Executable exec) throws XPathException {
        ValueOf text = new ValueOf(new StringLiteral('&' + this.nameAttribute + ';'), true, false);
        return text;
    }
}

