/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.BreakInstr;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.SaxonFinally;
import net.sf.saxon.style.SaxonIterate;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLChoose;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLIf;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Whitespace;

public class SaxonBreak
extends StyleElement {
    SaxonIterate saxonIterate = null;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a2 = 0; a2 < atts.getLength(); ++a2) {
            int nc = atts.getNameCode(a2);
            this.checkUnknownAttribute(nc);
        }
    }

    public void validate() throws XPathException {
        NodeInfo child;
        this.validatePosition();
        if (this.saxonIterate == null) {
            this.compileError(this.getDisplayName() + " must be a descendant of a saxon:iterate instruction", "XTSE0010");
            return;
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLFallback && this.mayContainFallback()) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within " + this.getDisplayName(), "XTSE0010");
                continue;
            }
            this.compileError("Child element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed within " + this.getDisplayName(), "XTSE0010");
        }
    }

    protected void validatePosition() throws XPathException {
        boolean isLast;
        NodeInfo inst;
        block5: {
            inst = this;
            isLast = true;
            do {
                if (!(inst instanceof XSLWhen)) {
                    NodeInfo sib;
                    AxisIterator sibs = inst.iterateAxis((byte)7);
                    while ((sib = (NodeInfo)sibs.next()) != null) {
                        if (sib instanceof XSLFallback || sib instanceof SaxonFinally) continue;
                        isLast = false;
                    }
                }
                if ((inst = inst.getParent()) instanceof SaxonIterate) break block5;
            } while (inst instanceof XSLWhen || inst instanceof XSLOtherwise || inst instanceof XSLIf || inst instanceof XSLChoose);
            if (inst == null) {
                this.compileError(this.getDisplayName() + " is not allowed at outermost level", "XTSE0010");
                return;
            }
            this.compileError(this.getDisplayName() + " is not allowed within " + inst.getDisplayName(), "XTSE0010");
            return;
        }
        this.saxonIterate = (SaxonIterate)inst;
        if (!isLast) {
            this.compileError(this.getDisplayName() + " must be the last instruction in the saxon:iterate loop", "XTSE0010");
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        return new BreakInstr();
    }
}

