/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class TextComparer
implements AtomicComparer,
Serializable {
    private AtomicComparer baseComparer;

    public TextComparer(AtomicComparer baseComparer) {
        this.baseComparer = baseComparer;
    }

    public AtomicComparer getBaseComparer() {
        return this.baseComparer;
    }

    public AtomicComparer provideContext(XPathContext context) {
        AtomicComparer newBase = this.baseComparer.provideContext(context);
        if (newBase != this.baseComparer) {
            return new TextComparer(newBase);
        }
        return this;
    }

    public int compareAtomicValues(AtomicValue a2, AtomicValue b2) throws ClassCastException, NoDynamicContextException {
        return this.baseComparer.compareAtomicValues(this.toStringValue(a2), this.toStringValue(b2));
    }

    private StringValue toStringValue(AtomicValue a2) {
        if (a2 instanceof StringValue) {
            return (StringValue)a2;
        }
        return new StringValue(a2 == null ? "" : a2.getStringValue());
    }

    public boolean comparesEqual(AtomicValue a2, AtomicValue b2) throws NoDynamicContextException {
        return this.compareAtomicValues(a2, b2) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue a2) throws NoDynamicContextException {
        return this.baseComparer.getComparisonKey(this.toStringValue(a2));
    }
}

