/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.sort.CollationURIResolver;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;

public class StandardCollationURIResolver
implements CollationURIResolver {
    private static final StandardCollationURIResolver theInstance = new StandardCollationURIResolver();

    private StandardCollationURIResolver() {
    }

    public static final StandardCollationURIResolver getInstance() {
        return theInstance;
    }

    public StringCollator resolve(String uri, String base, Configuration config) {
        try {
            if (uri.equals("http://saxon.sf.net/collation")) {
                return Configuration.getPlatform().makeCollation(config, new Properties(), uri);
            }
            if (uri.startsWith("http://saxon.sf.net/collation?")) {
                URI uuri;
                try {
                    uuri = new URI(uri);
                }
                catch (URISyntaxException err) {
                    throw new XPathException(err);
                }
                Properties props = new Properties();
                String query = uuri.getQuery();
                StringTokenizer queryTokenizer = new StringTokenizer(query, ";&");
                while (queryTokenizer.hasMoreElements()) {
                    String param = queryTokenizer.nextToken();
                    int eq = param.indexOf(61);
                    if (eq <= 0 || eq >= param.length() - 1) continue;
                    String kw = param.substring(0, eq);
                    String val = param.substring(eq + 1);
                    props.setProperty(kw, val);
                }
                return Configuration.getPlatform().makeCollation(config, props, uri);
            }
            return null;
        }
        catch (XPathException e2) {
            try {
                config.getErrorListener().warning(e2);
            }
            catch (TransformerException e1) {
                // empty catch block
            }
            return null;
        }
    }
}

