/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortKeyEvaluator;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public class SortExpression
extends Expression
implements SortKeyEvaluator {
    private Expression select = null;
    private SortKeyDefinition[] sortKeyDefinitions = null;
    private transient AtomicComparer[] comparators = null;

    public SortExpression(Expression select, SortKeyDefinition[] sortKeys) {
        this.select = select;
        this.sortKeyDefinitions = sortKeys;
        Iterator children = this.iterateSubExpressions();
        while (children.hasNext()) {
            Expression exp = (Expression)children.next();
            this.adoptChildExpression(exp);
        }
    }

    public Expression getBaseExpression() {
        return this.select;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(8);
        list.add(this.select);
        for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
            list.add(this.sortKeyDefinitions[i].getSortKey());
            Expression e2 = this.sortKeyDefinitions[i].order;
            if (e2 != null) {
                list.add(e2);
            }
            if ((e2 = this.sortKeyDefinitions[i].caseOrder) != null) {
                list.add(e2);
            }
            if ((e2 = this.sortKeyDefinitions[i].dataTypeExpression) != null) {
                list.add(e2);
            }
            if ((e2 = this.sortKeyDefinitions[i].language) != null) {
                list.add(e2);
            }
            if ((e2 = this.sortKeyDefinitions[i].collationName) != null) {
                list.add(e2);
            }
            if ((e2 = this.sortKeyDefinitions[i].stable) == null) continue;
            list.add(e2);
        }
        return list.iterator();
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.select.addToPathMap(pathMap, pathMapNodeSet);
        if (this.sortKeyDefinitions != null) {
            for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
                this.sortKeyDefinitions[i].getSortKey().addToPathMap(pathMap, target);
                Expression e2 = this.sortKeyDefinitions[i].getOrder();
                if (e2 != null) {
                    e2.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e2 = this.sortKeyDefinitions[i].getCaseOrder()) != null) {
                    e2.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e2 = this.sortKeyDefinitions[i].getDataTypeExpression()) != null) {
                    e2.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e2 = this.sortKeyDefinitions[i].getLanguage()) != null) {
                    e2.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e2 = this.sortKeyDefinitions[i].getCollationNameExpression()) == null) continue;
                e2.addToPathMap(pathMap, pathMapNodeSet);
            }
        }
        return target;
    }

    public boolean hasLoopingSubexpression(Expression child) {
        return this.isSortKey(child);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
            if (this.sortKeyDefinitions[i].getSortKey() == original) {
                this.sortKeyDefinitions[i].setSortKey(replacement);
                found = true;
            }
            if (this.sortKeyDefinitions[i].getOrder() == original) {
                this.sortKeyDefinitions[i].setOrder(replacement);
                found = true;
            }
            if (this.sortKeyDefinitions[i].getCaseOrder() == original) {
                this.sortKeyDefinitions[i].setCaseOrder(replacement);
                found = true;
            }
            if (this.sortKeyDefinitions[i].getDataTypeExpression() == original) {
                this.sortKeyDefinitions[i].setDataTypeExpression(replacement);
                found = true;
            }
            if (this.sortKeyDefinitions[i].getLanguage() == original) {
                this.sortKeyDefinitions[i].setLanguage(replacement);
                found = true;
            }
            if (this.sortKeyDefinitions[i].collationName == original) {
                this.sortKeyDefinitions[i].collationName = replacement;
                found = true;
            }
            if (this.sortKeyDefinitions[i].stable != original) continue;
            this.sortKeyDefinitions[i].stable = replacement;
            found = true;
        }
        return found;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int i;
        Expression select2 = visitor.typeCheck(this.select, contextItemType);
        if (select2 != this.select) {
            this.adoptChildExpression(select2);
            this.select = select2;
        }
        ItemType sortedItemType = this.select.getItemType(visitor.getConfiguration().getTypeHierarchy());
        boolean allKeysFixed = true;
        for (i = 0; i < this.sortKeyDefinitions.length; ++i) {
            if (this.sortKeyDefinitions[i].isFixed()) continue;
            allKeysFixed = false;
        }
        if (allKeysFixed) {
            this.comparators = new AtomicComparer[this.sortKeyDefinitions.length];
        }
        for (i = 0; i < this.sortKeyDefinitions.length; ++i) {
            Expression sortKey = this.sortKeyDefinitions[i].getSortKey();
            sortKey = visitor.typeCheck(sortKey, sortedItemType);
            if (visitor.getStaticContext().isInBackwardsCompatibleMode()) {
                sortKey = new FirstItemExpression(sortKey);
            } else {
                RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:sort/select"), 0);
                role.setErrorCode("XTTE1020");
                sortKey = CardinalityChecker.makeCardinalityChecker(sortKey, 24576, role);
            }
            this.sortKeyDefinitions[i].setSortKey(sortKey);
            if (this.sortKeyDefinitions[i].isFixed()) {
                AtomicComparer comp = this.sortKeyDefinitions[i].makeComparator(visitor.getStaticContext().makeEarlyEvaluationContext());
                this.sortKeyDefinitions[i].setFinalComparator(comp);
                if (allKeysFixed) {
                    this.comparators[i] = comp;
                }
            }
            if ((sortKey.getDependencies() & 0x1E) != 0) continue;
            visitor.getStaticContext().issueWarning("Sort key will have no effect because its value does not depend on the context item", sortKey);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression select2 = visitor.optimize(this.select, contextItemType);
        if (select2 != this.select) {
            this.adoptChildExpression(select2);
            this.select = select2;
        }
        ItemType sortedItemType = this.select.getItemType(visitor.getConfiguration().getTypeHierarchy());
        for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
            Expression sortKey = this.sortKeyDefinitions[i].getSortKey();
            sortKey = visitor.optimize(sortKey, sortedItemType);
            this.sortKeyDefinitions[i].setSortKey(sortKey);
        }
        if (Cardinality.allowsMany(this.select.getCardinality())) {
            return this;
        }
        return this.select;
    }

    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression exp = offer.accept(this);
        if (exp != null) {
            return exp;
        }
        this.select = this.doPromotion(this.select, offer);
        for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
            Expression sk2 = this.sortKeyDefinitions[i].getSortKey().promote(offer);
            this.sortKeyDefinitions[i].setSortKey(sk2);
            if (this.sortKeyDefinitions[i].order != null) {
                this.sortKeyDefinitions[i].order = this.sortKeyDefinitions[i].order.promote(offer);
            }
            if (this.sortKeyDefinitions[i].stable != null) {
                this.sortKeyDefinitions[i].stable = this.sortKeyDefinitions[i].stable.promote(offer);
            }
            if (this.sortKeyDefinitions[i].caseOrder != null) {
                this.sortKeyDefinitions[i].caseOrder = this.sortKeyDefinitions[i].caseOrder.promote(offer);
            }
            if (this.sortKeyDefinitions[i].dataTypeExpression != null) {
                this.sortKeyDefinitions[i].dataTypeExpression = this.sortKeyDefinitions[i].dataTypeExpression.promote(offer);
            }
            if (this.sortKeyDefinitions[i].language != null) {
                this.sortKeyDefinitions[i].language = this.sortKeyDefinitions[i].language.promote(offer);
            }
            if (this.sortKeyDefinitions[i].collationName == null) continue;
            this.sortKeyDefinitions[i].collationName = this.sortKeyDefinitions[i].collationName.promote(offer);
        }
        return this;
    }

    public boolean isSortKey(Expression child) {
        for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
            Expression exp = this.sortKeyDefinitions[i].getSortKey();
            if (exp != child) continue;
            return true;
        }
        return false;
    }

    public int computeCardinality() {
        return this.select.getCardinality();
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.select.getItemType(th);
    }

    public int computeSpecialProperties() {
        int props = 0;
        if ((this.select.getSpecialProperties() & 0x10000) != 0) {
            props |= 0x10000;
        }
        if ((this.select.getSpecialProperties() & 0x800000) != 0) {
            props |= 0x800000;
        }
        if ((this.select.getSpecialProperties() & 0x400000) != 0) {
            props |= 0x400000;
        }
        return props;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator iter = this.select.iterate(context);
        if (iter instanceof EmptyIterator) {
            return iter;
        }
        XPathContextMinor xpc = context.newMinorContext();
        xpc.setOrigin(this);
        AtomicComparer[] comps = this.comparators;
        if (this.comparators == null) {
            comps = new AtomicComparer[this.sortKeyDefinitions.length];
            for (int s = 0; s < this.sortKeyDefinitions.length; ++s) {
                AtomicComparer comp = this.sortKeyDefinitions[s].getFinalComparator();
                if (comp == null) {
                    comp = this.sortKeyDefinitions[s].makeComparator(xpc);
                }
                comps[s] = comp;
            }
        }
        iter = new SortedIterator(xpc, iter, this, comps);
        ((SortedIterator)iter).setHostLanguage(this.getHostLanguage());
        return iter;
    }

    public Item evaluateSortKey(int n, XPathContext c2) throws XPathException {
        return this.sortKeyDefinitions[n].getSortKey().evaluateItem(c2);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("sort");
        out.startSubsidiaryElement("select");
        this.select.explain(out);
        out.endSubsidiaryElement();
        for (int s = 0; s < this.sortKeyDefinitions.length; ++s) {
            out.startSubsidiaryElement("by");
            this.sortKeyDefinitions[s].getSortKey().explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

