/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;

public class NumericComparer
implements AtomicComparer,
Serializable {
    private static NumericComparer THE_INSTANCE = new NumericComparer();

    public static NumericComparer getInstance() {
        return THE_INSTANCE;
    }

    private NumericComparer() {
    }

    public AtomicComparer provideContext(XPathContext context) {
        return this;
    }

    public int compareAtomicValues(AtomicValue a2, AtomicValue b2) {
        double d2;
        double d1;
        if (a2 instanceof NumericValue) {
            d1 = ((NumericValue)a2).getDoubleValue();
        } else if (a2 == null) {
            d1 = Double.NaN;
        } else {
            try {
                d1 = Value.stringToNumber(a2.getStringValueCS());
            }
            catch (NumberFormatException err) {
                d1 = Double.NaN;
            }
        }
        if (b2 instanceof NumericValue) {
            d2 = ((NumericValue)b2).getDoubleValue();
        } else if (b2 == null) {
            d2 = Double.NaN;
        } else {
            try {
                d2 = Value.stringToNumber(b2.getStringValueCS());
            }
            catch (NumberFormatException err) {
                d2 = Double.NaN;
            }
        }
        if (Double.isNaN(d1)) {
            if (Double.isNaN(d2)) {
                return 0;
            }
            return -1;
        }
        if (Double.isNaN(d2)) {
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }

    public boolean comparesEqual(AtomicValue a2, AtomicValue b2) {
        return this.compareAtomicValues(a2, b2) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue a2) {
        if (a2 instanceof NumericValue) {
            return new ComparisonKey(635, this.toDoubleValue((NumericValue)a2));
        }
        if (a2 == null) {
            return new ComparisonKey(635, "NaN");
        }
        try {
            double d2 = Value.stringToNumber(a2.getStringValueCS());
            return new ComparisonKey(635, new DoubleValue(d2));
        }
        catch (NumberFormatException err) {
            return new ComparisonKey(635, "NaN");
        }
    }

    private DoubleValue toDoubleValue(NumericValue nv) {
        if (nv instanceof DoubleValue) {
            return (DoubleValue)nv;
        }
        return new DoubleValue(nv.getDoubleValue());
    }
}

