/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import net.sf.saxon.sort.StringCollator;

public class LowercaseFirstCollator
implements StringCollator,
Serializable {
    private StringCollator baseCollator;

    public LowercaseFirstCollator(StringCollator base) {
        this.baseCollator = base;
    }

    public int compareStrings(String a2, String b2) {
        int diff = this.baseCollator.compareStrings(a2, b2);
        if (diff != 0) {
            return diff;
        }
        int i = 0;
        int j = 0;
        while (true) {
            if (i < a2.length() && j < b2.length() && a2.charAt(i) == b2.charAt(j)) {
                ++i;
                ++j;
                continue;
            }
            while (i < a2.length() && !Character.isLetter(a2.charAt(i))) {
                ++i;
            }
            while (j < b2.length() && !Character.isLetter(b2.charAt(j))) {
                ++j;
            }
            if (i >= a2.length()) {
                return 0;
            }
            if (j >= b2.length()) {
                return 0;
            }
            boolean aLower = Character.isLowerCase(a2.charAt(i++));
            boolean bLower = Character.isLowerCase(b2.charAt(j++));
            if (aLower && !bLower) {
                return -1;
            }
            if (bLower && !aLower) break;
        }
        return 1;
    }

    public Object getCollationKey(String s) {
        return this.baseCollator.getCollationKey(s);
    }
}

