/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.sort.Sortable;

public class GenericSorter {
    private static final int SMALL = 7;
    private static final int MEDIUM = 7;
    private static final int LARGE = 40;

    protected GenericSorter() {
    }

    public static void quickSort(int fromIndex, int toIndex, Sortable c2) {
        GenericSorter.quickSort1(fromIndex, toIndex - fromIndex, c2);
    }

    private static void quickSort1(int off, int len, Sortable comp) {
        int a2;
        int c2;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(j - 1, j) > 0; --j) {
                    comp.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = GenericSorter.med3(l, l + s, l + 2 * s, comp);
                m = GenericSorter.med3(m - s, m, m + s, comp);
                n = GenericSorter.med3(n - 2 * s, n - s, n, comp);
            }
            c2 = comp.compare(m, n);
            m = comp.compare(l, m) < 0 ? (c2 < 0 ? m : (comp.compare(l, n) < 0 ? n : l)) : (c2 > 0 ? m : (comp.compare(l, n) > 0 ? n : l));
        }
        int b2 = a2 = off;
        int d2 = c2 = off + len - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(b2, m)) <= 0) {
                if (comparison == 0) {
                    if (a2 == m) {
                        m = b2;
                    } else if (b2 == m) {
                        m = a2;
                    }
                    comp.swap(a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(c2, m)) >= 0) {
                if (comparison == 0) {
                    if (c2 == m) {
                        m = d2;
                    } else if (d2 == m) {
                        m = c2;
                    }
                    comp.swap(c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            if (b2 == m) {
                m = d2;
            } else if (c2 == m) {
                m = c2;
            }
            comp.swap(b2++, c2--);
        }
        int s = Math.min(a2 - off, b2 - a2);
        int aa = off;
        int bb = b2 - s;
        while (--s >= 0) {
            comp.swap(aa++, bb++);
        }
        int n = off + len;
        s = Math.min(d2 - c2, n - d2 - 1);
        aa = b2;
        bb = n - s;
        while (--s >= 0) {
            comp.swap(aa++, bb++);
        }
        s = b2 - a2;
        if (s > 1) {
            GenericSorter.quickSort1(off, s, comp);
        }
        if ((s = d2 - c2) > 1) {
            GenericSorter.quickSort1(n - s, s, comp);
        }
    }

    private static int med3(int a2, int b2, int c2, Sortable comp) {
        int bc = comp.compare(b2, c2);
        return comp.compare(a2, b2) < 0 ? (bc < 0 ? b2 : (comp.compare(a2, c2) < 0 ? c2 : a2)) : (bc > 0 ? b2 : (comp.compare(a2, c2) > 0 ? c2 : a2));
    }

    public static void mergeSort(int fromIndex, int toIndex, Sortable c2) {
        if (toIndex - fromIndex < 7) {
            for (int i = fromIndex; i < toIndex; ++i) {
                for (int j = i; j > fromIndex && c2.compare(j - 1, j) > 0; --j) {
                    c2.swap(j, j - 1);
                }
            }
            return;
        }
        int mid = fromIndex + toIndex >>> 1;
        GenericSorter.mergeSort(fromIndex, mid, c2);
        GenericSorter.mergeSort(mid, toIndex, c2);
        if (c2.compare(mid - 1, mid) <= 0) {
            return;
        }
        GenericSorter.inplaceMerge(fromIndex, mid, toIndex, c2);
    }

    private static void inplaceMerge(int first, int middle, int last, Sortable comp) {
        int secondCut;
        int mid;
        int half;
        int len;
        int _first;
        int firstCut;
        if (first >= middle || middle >= last) {
            return;
        }
        if (last - first == 2) {
            if (comp.compare(middle, first) < 0) {
                comp.swap(first, middle);
            }
            return;
        }
        if (middle - first > last - middle) {
            firstCut = first + (middle - first >>> 1);
            _first = middle;
            len = last - _first;
            while (len > 0) {
                half = len >>> 1;
                mid = _first + half;
                if (comp.compare(mid, firstCut) < 0) {
                    _first = mid + 1;
                    len -= half + 1;
                    continue;
                }
                len = half;
            }
            secondCut = _first;
        } else {
            secondCut = middle + (last - middle >>> 1);
            _first = first;
            len = middle - _first;
            while (len > 0) {
                half = len >>> 1;
                mid = _first + half;
                if (comp.compare(secondCut, mid) < 0) {
                    len = half;
                    continue;
                }
                _first = mid + 1;
                len -= half + 1;
            }
            firstCut = _first;
        }
        int first2 = firstCut;
        int middle2 = middle;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                comp.swap(first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                comp.swap(first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                comp.swap(first1++, last1);
            }
        }
        middle = firstCut + (secondCut - middle);
        GenericSorter.inplaceMerge(first, firstCut, middle, comp);
        GenericSorter.inplaceMerge(middle, secondCut, last, comp);
    }
}

