/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.value.AtomicValue;

public class EmptyGreatestComparer
implements AtomicComparer,
Serializable {
    private AtomicComparer baseComparer;

    public EmptyGreatestComparer(AtomicComparer baseComparer) {
        this.baseComparer = baseComparer;
    }

    public AtomicComparer getBaseComparer() {
        return this.baseComparer;
    }

    public AtomicComparer provideContext(XPathContext context) {
        AtomicComparer newBase = this.baseComparer.provideContext(context);
        if (newBase != this.baseComparer) {
            return new EmptyGreatestComparer(newBase);
        }
        return this;
    }

    public int compareAtomicValues(AtomicValue a2, AtomicValue b2) throws NoDynamicContextException {
        if (a2 == null) {
            if (b2 == null) {
                return 0;
            }
            return 1;
        }
        if (b2 == null) {
            return -1;
        }
        if (a2.isNaN()) {
            return b2.isNaN() ? 0 : 1;
        }
        if (b2.isNaN()) {
            return -1;
        }
        return this.baseComparer.compareAtomicValues(a2, b2);
    }

    public boolean comparesEqual(AtomicValue a2, AtomicValue b2) throws NoDynamicContextException {
        return a2 == null && b2 == null || this.baseComparer.comparesEqual(a2, b2);
    }

    public ComparisonKey getComparisonKey(AtomicValue a2) throws NoDynamicContextException {
        return a2 == null ? new ComparisonKey(15, "()") : this.baseComparer.getComparisonKey(a2);
    }
}

