/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;

public class DoubleSortComparer
implements AtomicComparer {
    private static DoubleSortComparer THE_INSTANCE = new DoubleSortComparer();

    public static DoubleSortComparer getInstance() {
        return THE_INSTANCE;
    }

    private DoubleSortComparer() {
    }

    public AtomicComparer provideContext(XPathContext context) {
        return this;
    }

    public int compareAtomicValues(AtomicValue a2, AtomicValue b2) {
        if (a2 == null) {
            if (b2 == null) {
                return 0;
            }
            return -1;
        }
        if (b2 == null) {
            return 1;
        }
        NumericValue an = (NumericValue)a2;
        NumericValue bn = (NumericValue)b2;
        if (an.isNaN()) {
            return bn.isNaN() ? 0 : -1;
        }
        if (bn.isNaN()) {
            return 1;
        }
        return an.compareTo(bn);
    }

    public boolean comparesEqual(AtomicValue a2, AtomicValue b2) {
        return this.compareAtomicValues(a2, b2) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue a2) {
        if (((NumericValue)a2).isNaN()) {
            return new ComparisonKey(635, AtomicSortComparer.COLLATION_KEY_NaN);
        }
        return new ComparisonKey(635, a2);
    }
}

