/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.value.AtomicValue;

public class ComparableAtomicValueComparer
implements AtomicComparer {
    private static ComparableAtomicValueComparer THE_INSTANCE = new ComparableAtomicValueComparer();

    public static ComparableAtomicValueComparer getInstance() {
        return THE_INSTANCE;
    }

    protected ComparableAtomicValueComparer() {
    }

    public AtomicComparer provideContext(XPathContext context) {
        return this;
    }

    public int compareAtomicValues(AtomicValue a2, AtomicValue b2) {
        if (a2 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return 1;
        }
        return ((Comparable)((Object)a2)).compareTo(b2);
    }

    public boolean comparesEqual(AtomicValue a2, AtomicValue b2) {
        return a2.equals(b2);
    }

    public ComparisonKey getComparisonKey(AtomicValue a2) {
        return new ComparisonKey(a2.getPrimitiveType().getFingerprint(), a2);
    }
}

