/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.sort.SubstringMatcher;

public class CodepointCollator
implements StringCollator,
SubstringMatcher,
Serializable {
    private static CodepointCollator theInstance = new CodepointCollator();

    public static CodepointCollator getInstance() {
        return theInstance;
    }

    public int compareStrings(String a2, String b2) {
        return this.compareCS(a2, b2);
    }

    public int compareCS(CharSequence a2, CharSequence b2) {
        int nextb;
        int nexta;
        int c2;
        int alen = a2.length();
        int blen = b2.length();
        int i = 0;
        int j = 0;
        do {
            if (i == alen) {
                if (j == blen) {
                    return 0;
                }
                return -1;
            }
            if (j == blen) {
                return 1;
            }
            if ((nexta = a2.charAt(i++)) >= 55296 && nexta <= 56319) {
                nexta = (nexta - 55296) * 1024 + (a2.charAt(i++) - 56320) + 65536;
            }
            if ((nextb = b2.charAt(j++)) < 55296 || nextb > 56319) continue;
            nextb = (nextb - 55296) * 1024 + (b2.charAt(j++) - 56320) + 65536;
        } while ((c2 = nexta - nextb) == 0);
        return c2;
    }

    public boolean comparesEqual(String s1, String s2) {
        return s1.equals(s2);
    }

    public boolean contains(String s1, String s2) {
        return s1.indexOf(s2) >= 0;
    }

    public boolean endsWith(String s1, String s2) {
        return s1.endsWith(s2);
    }

    public boolean startsWith(String s1, String s2) {
        return s1.startsWith(s2);
    }

    public String substringAfter(String s1, String s2) {
        int i = s1.indexOf(s2);
        if (i < 0) {
            return "";
        }
        return s1.substring(i + s2.length());
    }

    public String substringBefore(String s1, String s2) {
        int j = s1.indexOf(s2);
        if (j < 0) {
            return "";
        }
        return s1.substring(0, j);
    }

    public Object getCollationKey(String s) {
        return s;
    }
}

