/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class CodepointCollatingComparer
implements AtomicComparer {
    private static CodepointCollator collator = CodepointCollator.getInstance();
    private static CodepointCollatingComparer THE_INSTANCE = new CodepointCollatingComparer();

    public static CodepointCollatingComparer getInstance() {
        return THE_INSTANCE;
    }

    private CodepointCollatingComparer() {
    }

    public AtomicComparer provideContext(XPathContext context) {
        return this;
    }

    public int compareAtomicValues(AtomicValue a2, AtomicValue b2) {
        if (a2 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return 1;
        }
        StringValue as = (StringValue)a2;
        StringValue bs = (StringValue)b2;
        if (as.containsSurrogatePairs() || bs.containsSurrogatePairs()) {
            return collator.compareCS(as.getStringValueCS(), bs.getStringValueCS());
        }
        return as.getStringValue().compareTo(bs.getStringValue());
    }

    public boolean comparesEqual(AtomicValue a2, AtomicValue b2) {
        StringValue as = (StringValue)a2;
        StringValue bs = (StringValue)b2;
        return as.codepointEquals(bs);
    }

    public ComparisonKey getComparisonKey(AtomicValue a2) {
        StringValue as = (StringValue)a2;
        return new ComparisonKey(513, as.getStringValue());
    }
}

