/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CalendarValueComparer;
import net.sf.saxon.sort.CodepointCollatingComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollatingAtomicComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.sort.DecimalSortComparer;
import net.sf.saxon.sort.DoubleSortComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class AtomicSortComparer
implements AtomicComparer {
    private StringCollator collator;
    private XPathContext context;
    private int itemType;
    protected static StructuredQName COLLATION_KEY_NaN = new StructuredQName("saxon", "http://saxon.sf.net/collation-key", "NaN");

    public static AtomicComparer makeSortComparer(StringCollator collator, int itemType, XPathContext context) {
        switch (itemType) {
            case 513: 
            case 529: 
            case 631: {
                if (collator instanceof CodepointCollator) {
                    return CodepointCollatingComparer.getInstance();
                }
                return new CollatingAtomicComparer(collator, Configuration.getPlatform());
            }
            case 515: 
            case 532: {
                return DecimalSortComparer.getDecimalSortComparerInstance();
            }
            case 516: 
            case 517: 
            case 635: {
                return DoubleSortComparer.getInstance();
            }
            case 519: 
            case 520: 
            case 521: {
                return new CalendarValueComparer(context);
            }
        }
        return new AtomicSortComparer(collator, itemType, context);
    }

    private AtomicSortComparer(StringCollator collator, int itemType, XPathContext context) {
        this.collator = collator;
        if (collator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.context = context;
        this.itemType = itemType;
    }

    public AtomicComparer provideContext(XPathContext context) {
        return new AtomicSortComparer(this.collator, this.itemType, context);
    }

    public StringCollator getStringCollator() {
        return this.collator;
    }

    public int getItemType() {
        return this.itemType;
    }

    public int compareAtomicValues(AtomicValue a2, AtomicValue b2) throws NoDynamicContextException {
        if (a2 == null) {
            if (b2 == null) {
                return 0;
            }
            return -1;
        }
        if (b2 == null) {
            return 1;
        }
        if (a2 instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)a2).compareTo(b2, this.collator, this.context);
        }
        if (b2 instanceof UntypedAtomicValue) {
            return -((UntypedAtomicValue)b2).compareTo(a2, this.collator, this.context);
        }
        if (a2.isNaN()) {
            return b2.isNaN() ? 0 : -1;
        }
        if (b2.isNaN()) {
            return 1;
        }
        if (a2 instanceof StringValue && b2 instanceof StringValue) {
            if (this.collator instanceof CodepointCollator) {
                return ((CodepointCollator)this.collator).compareCS(a2.getStringValueCS(), b2.getStringValueCS());
            }
            return this.collator.compareStrings(a2.getStringValue(), b2.getStringValue());
        }
        Comparable ac = (Comparable)a2.getXPathComparable(true, this.collator, this.context);
        Comparable bc = (Comparable)b2.getXPathComparable(true, this.collator, this.context);
        if (ac == null || bc == null) {
            throw new ClassCastException("Values are not comparable (" + Type.displayTypeName(a2) + ", " + Type.displayTypeName(b2) + ')');
        }
        return ac.compareTo(bc);
    }

    public boolean comparesEqual(AtomicValue a2, AtomicValue b2) throws NoDynamicContextException {
        return this.compareAtomicValues(a2, b2) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue a2) throws NoDynamicContextException {
        if (a2 instanceof NumericValue) {
            if (((NumericValue)a2).isNaN()) {
                return new ComparisonKey(635, COLLATION_KEY_NaN);
            }
            return new ComparisonKey(635, a2);
        }
        if (a2 instanceof StringValue) {
            Platform platform = Configuration.getPlatform();
            if (platform.canReturnCollationKeys(this.collator)) {
                return new ComparisonKey(513, this.collator.getCollationKey(a2.getStringValue()));
            }
            return new ComparisonKey(513, a2);
        }
        if (a2 instanceof CalendarValue) {
            CalendarValue cv = (CalendarValue)a2;
            if (cv.hasTimezone()) {
                return new ComparisonKey(a2.getTypeLabel().getPrimitiveType(), a2);
            }
            cv = (CalendarValue)cv.copyAsSubType(cv.getTypeLabel());
            cv.setTimezoneInMinutes(this.context.getImplicitTimezone());
            return new ComparisonKey(cv.getTypeLabel().getPrimitiveType(), cv);
        }
        if (a2 instanceof DurationValue) {
            return new ComparisonKey(518, a2);
        }
        return new ComparisonKey(a2.getTypeLabel().getPrimitiveType(), a2);
    }
}

