/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pull.DocumentEventIgnorer;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.TreeWalker;
import net.sf.saxon.pull.UnconstructedElement;
import net.sf.saxon.pull.UnconstructedParent;
import net.sf.saxon.sort.IntArraySet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class VirtualTreeWalker
implements PullProvider,
NamespaceDeclarations {
    private PipelineConfiguration pipe;
    private int currentEvent = 0;
    private int nameCode;
    private int nextNameCode;
    private ParentNodeConstructor instruction;
    private XPathContext context;
    private Stack constructorStack = new Stack();
    private Stack iteratorStack = new Stack();
    private PullProvider subordinateTreeWalker = null;
    private boolean alreadyRead = false;
    private boolean allowAttributes = false;
    private int stripDepth = -1;
    private AttributeCollectionImpl attributes;
    private boolean foundAttributes;
    private int[] activeNamespaces;
    private ArrayList additionalNamespaces = new ArrayList(10);
    private FastStringBuffer textNodeBuffer = new FastStringBuffer(100);
    private CharSequence currentTextValue = null;

    public VirtualTreeWalker(ParentNodeConstructor instruction, XPathContext context) {
        this.instruction = instruction;
        this.context = context;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public int next() throws XPathException {
        try {
            if (this.subordinateTreeWalker != null) {
                this.currentEvent = this.subordinateTreeWalker.next();
                if (this.currentEvent == -1) {
                    this.subordinateTreeWalker = null;
                    return this.next();
                }
                return this.currentEvent;
            }
            if (this.currentEvent == 0) {
                this.constructorStack.push(this.instruction);
                if (this.stripDepth < 0 && this.instruction.getValidationMode() == 4) {
                    this.stripDepth = this.constructorStack.size();
                }
                SequenceIterator content = this.instruction.getContentExpression().iterate(this.context);
                this.iteratorStack.push(content);
                if (this.instruction instanceof DocumentInstr) {
                    this.currentEvent = 2;
                    this.nameCode = -1;
                } else {
                    this.currentEvent = 4;
                    this.nameCode = ((ElementCreator)this.instruction).getNameCode(this.context);
                    this.allowAttributes = true;
                    this.processAttributesAndNamespaces((ElementCreator)this.instruction, content);
                    this.allowAttributes = false;
                    this.alreadyRead = true;
                }
                return this.currentEvent;
            }
            if (this.iteratorStack.isEmpty()) {
                if (this.currentEvent == 2 || this.currentEvent == 4) {
                    SequenceIterator iter = this.instruction.getContentExpression().iterate(this.context);
                    this.constructorStack.push(this.instruction);
                    if (this.stripDepth < 0 && this.instruction.getValidationMode() == 4) {
                        this.stripDepth = this.constructorStack.size();
                    }
                    this.iteratorStack.push(iter);
                } else {
                    if (this.currentEvent == 3 || this.currentEvent == 5) {
                        this.currentEvent = -1;
                        return this.currentEvent;
                    }
                    this.currentEvent = this.instruction instanceof DocumentInstr ? 3 : 5;
                    return this.currentEvent;
                }
            }
            SequenceIterator iterator = (SequenceIterator)this.iteratorStack.peek();
            if (this.alreadyRead) {
                Item item = iterator.current();
                this.alreadyRead = false;
                this.nameCode = this.nextNameCode;
                return this.processItem(iterator, item);
            }
            return this.processItem(iterator, iterator.next());
        }
        catch (XPathException e2) {
            this.context.getController().reportFatalError(e2);
            throw e2;
        }
    }

    private int processItem(SequenceIterator iterator, Item item) throws XPathException {
        if (item == null) {
            ParentNodeConstructor inst;
            if (this.stripDepth == this.constructorStack.size()) {
                this.stripDepth = -1;
            }
            if ((inst = (ParentNodeConstructor)this.constructorStack.pop()) instanceof DocumentInstr) {
                this.iteratorStack.pop();
                if (this.iteratorStack.isEmpty()) {
                    this.currentEvent = 3;
                    this.nameCode = -1;
                    return this.currentEvent;
                }
                return this.next();
            }
            this.currentEvent = 5;
            this.nameCode = -1;
            this.iteratorStack.pop();
            return this.currentEvent;
        }
        if (item instanceof UnconstructedParent) {
            UnconstructedParent parent = (UnconstructedParent)item;
            ParentNodeConstructor inst = parent.getInstruction();
            this.constructorStack.push(inst);
            if (this.stripDepth < 0 && inst.getValidationMode() == 4) {
                this.stripDepth = this.constructorStack.size();
            }
            SequenceIterator content = inst.getContentExpression().iterate(parent.getXPathContext());
            if (inst instanceof DocumentInstr) {
                this.iteratorStack.push(content);
                return this.next();
            }
            this.currentEvent = 4;
            this.nameCode = ((UnconstructedElement)item).getNameCode();
            this.processAttributesAndNamespaces((ElementCreator)inst, content);
            this.alreadyRead = true;
            this.iteratorStack.push(content);
            return this.currentEvent;
        }
        if (item instanceof AtomicValue) {
            Item next;
            this.currentTextValue = this.textNodeBuffer;
            this.textNodeBuffer.setLength(0);
            this.textNodeBuffer.append(item.getStringValueCS());
            while ((next = iterator.next()) instanceof AtomicValue) {
                this.textNodeBuffer.append(' ');
                this.textNodeBuffer.append(next.getStringValueCS());
            }
            this.currentEvent = 8;
            this.nameCode = -1;
            this.alreadyRead = true;
            return this.currentEvent;
        }
        this.nameCode = ((NodeInfo)item).getNameCode();
        switch (((NodeInfo)item).getNodeKind()) {
            case 3: {
                this.currentEvent = 8;
                this.currentTextValue = item.getStringValueCS();
                return this.currentEvent;
            }
            case 8: {
                this.currentEvent = 9;
                return this.currentEvent;
            }
            case 7: {
                this.currentEvent = 10;
                return this.currentEvent;
            }
            case 2: {
                if (!this.allowAttributes) {
                    XPathException de;
                    if (this.constructorStack.peek() instanceof DocumentInstr) {
                        de = new XPathException("Attributes cannot be attached to a document node");
                        if (this.pipe.getHostLanguage() == 51) {
                            de.setErrorCode("XQTY0004");
                        } else {
                            de.setErrorCode("XTDE0420");
                        }
                    } else {
                        de = new XPathException("Attributes in the content of an element must come before the child nodes");
                        if (this.pipe.getHostLanguage() == 51) {
                            de.setErrorCode("XQDY0024");
                        } else {
                            de.setErrorCode("XTDE0410");
                        }
                    }
                    de.setXPathContext(this.context);
                    de.setLocator(this.getSourceLocator());
                    throw de;
                }
                this.currentEvent = 6;
                return this.currentEvent;
            }
            case 13: {
                if (!this.allowAttributes) {
                    XPathException de = new XPathException("Namespace nodes in the content of an element must come before the child nodes");
                    de.setErrorCode("XTDE0410");
                    de.setXPathContext(this.context);
                    de.setLocator(this.getSourceLocator());
                    throw de;
                }
                this.currentEvent = 7;
                return this.currentEvent;
            }
            case 1: {
                this.subordinateTreeWalker = TreeWalker.makeTreeWalker((NodeInfo)item);
                this.subordinateTreeWalker.setPipelineConfiguration(this.pipe);
                this.currentEvent = this.subordinateTreeWalker.next();
                this.nameCode = this.subordinateTreeWalker.getNameCode();
                return this.currentEvent;
            }
            case 9: {
                this.subordinateTreeWalker = TreeWalker.makeTreeWalker((NodeInfo)item);
                this.subordinateTreeWalker.setPipelineConfiguration(this.pipe);
                this.subordinateTreeWalker = new DocumentEventIgnorer(this.subordinateTreeWalker);
                this.subordinateTreeWalker.setPipelineConfiguration(this.pipe);
                this.currentEvent = this.subordinateTreeWalker.next();
                this.nameCode = -1;
                return this.currentEvent;
            }
        }
        throw new IllegalStateException();
    }

    private void processAttributesAndNamespaces(ElementCreator inst, SequenceIterator content) throws XPathException {
        Item next;
        boolean preserve;
        this.foundAttributes = false;
        this.additionalNamespaces.clear();
        this.activeNamespaces = inst.getActiveNamespaces();
        if (this.activeNamespaces == null) {
            this.activeNamespaces = IntArraySet.EMPTY_INT_ARRAY;
        }
        boolean bl = preserve = this.stripDepth < 0;
        while ((next = content.next()) != null && next instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)next;
            int kind = node.getNodeKind();
            if (kind == 2) {
                int index;
                if (!this.foundAttributes) {
                    if (this.attributes == null) {
                        this.attributes = new AttributeCollectionImpl(this.context.getConfiguration());
                    }
                    this.attributes.clear();
                    this.foundAttributes = true;
                }
                if ((index = this.attributes.getIndexByFingerprint(node.getFingerprint())) >= 0) {
                    if (this.context.getController().getExecutable().getHostLanguage() == 50) {
                        this.attributes.setAttribute(index, node.getNameCode(), preserve ? node.getTypeAnnotation() : 631, node.getStringValue(), 0L, 0);
                        continue;
                    }
                    XPathException de = new XPathException("The attributes of an element must have distinct names");
                    de.setErrorCode("XQDY0025");
                    de.setXPathContext(this.context);
                    de.setLocator(this.getSourceLocator());
                    throw de;
                }
                this.attributes.addAttribute(node.getNameCode(), preserve ? node.getTypeAnnotation() : 631, node.getStringValue(), 0L, 0);
                continue;
            }
            if (kind == 13) {
                this.additionalNamespaces.add(node);
                continue;
            }
            if (kind == 3 && node.getStringValue().length() == 0) continue;
            this.nextNameCode = ((NodeInfo)next).getNameCode();
            break;
        }
    }

    public int current() {
        return this.currentEvent;
    }

    public AttributeCollection getAttributes() throws XPathException {
        if (this.subordinateTreeWalker != null) {
            return this.subordinateTreeWalker.getAttributes();
        }
        if (this.foundAttributes) {
            return this.attributes;
        }
        return AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION;
    }

    public NamespaceDeclarations getNamespaceDeclarations() throws XPathException {
        if (this.subordinateTreeWalker != null) {
            return this.subordinateTreeWalker.getNamespaceDeclarations();
        }
        return this;
    }

    public int skipToMatchingEnd() throws XPathException {
        Item next;
        if (this.currentEvent != 2 && this.currentEvent != 4) {
            throw new IllegalStateException();
        }
        if (this.subordinateTreeWalker != null) {
            return this.subordinateTreeWalker.skipToMatchingEnd();
        }
        SequenceIterator content = (SequenceIterator)this.iteratorStack.peek();
        if (this.alreadyRead) {
            this.alreadyRead = false;
        }
        while ((next = content.next()) != null) {
        }
        return this.currentEvent == 2 ? 3 : 5;
    }

    public void close() {
        if (this.subordinateTreeWalker != null) {
            this.subordinateTreeWalker.close();
        }
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public int getNameCode() {
        if (this.subordinateTreeWalker != null) {
            return this.subordinateTreeWalker.getNameCode();
        }
        return this.nameCode;
    }

    public int getFingerprint() {
        int nc = this.getNameCode();
        if (nc == -1) {
            return -1;
        }
        return nc & 0xFFFFF;
    }

    public CharSequence getStringValue() throws XPathException {
        Item next;
        if (this.subordinateTreeWalker != null) {
            return this.subordinateTreeWalker.getStringValue();
        }
        if (this.currentEvent == 8) {
            return this.currentTextValue;
        }
        if (this.currentEvent != 4 && this.currentEvent != 2) {
            SequenceIterator content = (SequenceIterator)this.iteratorStack.peek();
            if (content.current() == null) {
                return "";
            }
            return content.current().getStringValue();
        }
        FastStringBuffer sb = new FastStringBuffer(100);
        SequenceIterator content = (SequenceIterator)this.iteratorStack.peek();
        boolean previousAtomic = false;
        if (this.alreadyRead) {
            Item current = content.current();
            if (current == null) {
                return "";
            }
            this.processText(current, sb);
            previousAtomic = current instanceof AtomicValue;
            this.alreadyRead = false;
        }
        while ((next = content.next()) != null) {
            boolean atomic = next instanceof AtomicValue;
            if (atomic && previousAtomic) {
                sb.append(' ');
            }
            this.processText(next, sb);
            previousAtomic = atomic;
        }
        return sb;
    }

    private void processText(Item item, FastStringBuffer sb) {
        if (item instanceof UnconstructedParent) {
            sb.append(item.getStringValueCS());
        } else if (item instanceof AtomicValue) {
            sb.append(item.getStringValueCS());
        } else {
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 1: 
                case 3: 
                case 9: {
                    sb.append(node.getStringValueCS());
                }
            }
        }
    }

    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public int getTypeAnnotation() {
        if (this.subordinateTreeWalker != null && this.stripDepth < 0) {
            return this.subordinateTreeWalker.getTypeAnnotation();
        }
        return -1;
    }

    public SourceLocator getSourceLocator() {
        return this.instruction;
    }

    public int getNumberOfNamespaces() {
        return this.activeNamespaces.length + this.additionalNamespaces.size();
    }

    public String getPrefix(int index) {
        if (index < this.activeNamespaces.length) {
            return this.getNamePool().getPrefixFromNamespaceCode(this.activeNamespaces[index]);
        }
        return ((NodeInfo)this.additionalNamespaces.get(index - this.activeNamespaces.length)).getLocalPart();
    }

    public String getURI(int index) {
        if (index < this.activeNamespaces.length) {
            return this.getNamePool().getURIFromNamespaceCode(this.activeNamespaces[index]);
        }
        return ((NodeInfo)this.additionalNamespaces.get(index - this.activeNamespaces.length)).getStringValue();
    }

    public int getNamespaceCode(int index) {
        if (index < this.activeNamespaces.length) {
            return this.activeNamespaces[index];
        }
        return this.getNamePool().allocateNamespaceCode(this.getPrefix(index), this.getURI(index));
    }

    public int[] getNamespaceCodes(int[] buffer) {
        if (buffer.length < this.getNumberOfNamespaces()) {
            buffer = new int[this.getNumberOfNamespaces()];
        } else {
            buffer[this.getNumberOfNamespaces()] = -1;
        }
        for (int i = 0; i < this.getNumberOfNamespaces(); ++i) {
            buffer[i] = this.getNamespaceCode(i);
        }
        return buffer;
    }

    public List getUnparsedEntities() {
        return null;
    }
}

