/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.Position;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public final class LocationPathPattern
extends Pattern {
    public Pattern parentPattern = null;
    public Pattern ancestorPattern = null;
    public NodeTest nodeTest = AnyNodeTest.getInstance();
    protected Expression[] filters = null;
    protected int numberOfFilters = 0;
    protected Expression equivalentExpr = null;
    protected boolean firstElementPattern = false;
    protected boolean lastElementPattern = false;
    protected boolean specialFilter = false;
    private Expression variableBinding = null;
    private NodeTest refinedNodeTest = null;

    public void addFilter(Expression filter) {
        if (this.filters == null) {
            this.filters = new Expression[3];
        } else if (this.numberOfFilters == this.filters.length) {
            Expression[] f2 = new Expression[this.numberOfFilters * 2];
            System.arraycopy(this.filters, 0, f2, 0, this.numberOfFilters);
            this.filters = f2;
        }
        this.filters[this.numberOfFilters++] = filter;
        filter.setContainer(this);
    }

    public void setExecutable(Executable executable) {
        super.setExecutable(executable);
        if (this.parentPattern != null) {
            this.parentPattern.setExecutable(executable);
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern.setExecutable(executable);
        }
    }

    public Expression[] getFilters() {
        return this.filters;
    }

    public Pattern getParentPattern() {
        return this.parentPattern;
    }

    public Pattern getAncestorPattern() {
        return this.ancestorPattern;
    }

    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.parentPattern == null && this.ancestorPattern == null && this.filters == null && !this.firstElementPattern && !this.lastElementPattern) {
            NodeTestPattern ntp = new NodeTestPattern(this.nodeTest);
            ntp.setSystemId(this.getSystemId());
            ntp.setLineNumber(this.getLineNumber());
            return ntp;
        }
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.simplify(visitor);
        } else if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.simplify(visitor);
        }
        if (this.filters != null) {
            for (int i = this.numberOfFilters - 1; i >= 0; --i) {
                Expression filter = this.filters[i];
                this.filters[i] = filter = visitor.simplify(filter);
            }
        }
        return this;
    }

    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.analyze(visitor, contextItemType);
            AxisExpression step = this.nodeTest.getPrimitiveType() == 2 ? new AxisExpression(2, this.nodeTest) : new AxisExpression(3, this.nodeTest);
            step.setLocationId(env.getLocationMap().allocateLocationId(env.getSystemId(), this.getLineNumber()));
            step.setContainer(this);
            Expression exp = visitor.typeCheck(step, this.parentPattern.getNodeTest());
            this.refinedNodeTest = (NodeTest)exp.getItemType(th);
        } else if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.analyze(visitor, contextItemType);
        }
        if (this.filters != null) {
            Optimizer opt = visitor.getConfiguration().getOptimizer();
            for (int i = this.numberOfFilters - 1; i >= 0; --i) {
                Expression filter = visitor.typeCheck(this.filters[i], this.getNodeTest());
                filter = ExpressionTool.unsortedIfHomogeneous(opt, filter);
                this.filters[i] = filter = visitor.optimize(filter, this.getNodeTest());
                if (Literal.isConstantBoolean(filter, true)) {
                    if (i == this.numberOfFilters - 1) {
                        --this.numberOfFilters;
                    } else {
                        System.arraycopy(this.filters, i + 1, this.filters, i, this.numberOfFilters - i - 1);
                        --this.numberOfFilters;
                    }
                    this.filters[this.numberOfFilters] = null;
                    continue;
                }
                if (!Literal.isConstantBoolean(filter, false)) continue;
                return new NodeTestPattern(EmptySequenceTest.getInstance());
            }
        }
        if (this.nodeTest.getPrimitiveType() == 1 && this.numberOfFilters == 1) {
            ComparisonExpression comp;
            if (Literal.isConstantOne(this.filters[0])) {
                this.firstElementPattern = true;
                this.specialFilter = true;
                this.numberOfFilters = 0;
                this.filters = null;
            } else if (this.filters[0] instanceof ComparisonExpression && ((comp = (ComparisonExpression)((Object)this.filters[0])).getSingletonOperator() == 44 && comp.getOperands()[0] instanceof Position && Literal.isConstantOne(comp.getOperands()[1]) || comp.getOperands()[1] instanceof Position && Literal.isConstantOne(comp.getOperands()[0]))) {
                this.firstElementPattern = true;
                this.specialFilter = true;
                this.numberOfFilters = 0;
                this.filters = null;
            }
        }
        if (this.nodeTest.getPrimitiveType() == 1 && this.numberOfFilters == 1 && this.filters[0] instanceof IsLastExpression && ((IsLastExpression)this.filters[0]).getCondition()) {
            this.lastElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.isPositional(th)) {
            this.equivalentExpr = this.makePositionalExpression();
            this.equivalentExpr = visitor.typeCheck(this.equivalentExpr, contextItemType);
            this.specialFilter = true;
        }
        return this;
    }

    public int getDependencies() {
        int dependencies = 0;
        if (this.parentPattern != null) {
            dependencies |= this.parentPattern.getDependencies();
        }
        if (this.ancestorPattern != null) {
            dependencies |= this.ancestorPattern.getDependencies();
        }
        for (int i = 0; i < this.numberOfFilters; ++i) {
            dependencies |= this.filters[i].getDependencies();
        }
        return dependencies &= 0x80;
    }

    public Iterator iterateSubExpressions() {
        Iterator[] pair;
        Iterator iter = this.numberOfFilters == 0 ? Collections.EMPTY_LIST.iterator() : Arrays.asList(this.filters).subList(0, this.numberOfFilters).iterator();
        if (this.variableBinding != null) {
            pair = new Iterator[]{iter, new MonoIterator(this.variableBinding)};
            iter = new MultiIterator(pair);
        }
        if (this.parentPattern != null) {
            pair = new Iterator[]{iter, this.parentPattern.iterateSubExpressions()};
            iter = new MultiIterator(pair);
        }
        if (this.ancestorPattern != null) {
            pair = new Iterator[]{iter, this.ancestorPattern.iterateSubExpressions()};
            iter = new MultiIterator(pair);
        }
        return iter;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < this.numberOfFilters; ++i) {
            if (this.filters[i] != original) continue;
            this.filters[i] = replacement;
            found = true;
        }
        if (this.parentPattern instanceof LocationPathPattern) {
            found |= this.parentPattern.replaceSubExpression(original, replacement);
        }
        if (this.ancestorPattern instanceof LocationPathPattern) {
            found |= this.ancestorPattern.replaceSubExpression(original, replacement);
        }
        if (this.variableBinding == original) {
            this.variableBinding = replacement;
            found = true;
        }
        return found;
    }

    public int allocateSlots(StaticContext env, SlotManager slotManager, int nextFree) {
        if (this.variableBinding != null) {
            nextFree = ExpressionTool.allocateSlots(this.variableBinding, nextFree, slotManager);
        }
        for (int i = 0; i < this.numberOfFilters; ++i) {
            nextFree = ExpressionTool.allocateSlots(this.filters[i], nextFree, slotManager);
        }
        if (this.parentPattern instanceof LocationPathPattern) {
            nextFree = this.parentPattern.allocateSlots(env, slotManager, nextFree);
        }
        if (this.ancestorPattern instanceof LocationPathPattern) {
            nextFree = this.ancestorPattern.allocateSlots(env, slotManager, nextFree);
        }
        return nextFree;
    }

    public void promote(PromotionOffer offer) throws XPathException {
        if (this.parentPattern != null) {
            this.parentPattern.promote(offer);
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern.promote(offer);
        }
        for (int i = 0; i < this.numberOfFilters; ++i) {
            this.filters[i] = this.filters[i].promote(offer);
        }
    }

    private Expression makePositionalExpression() {
        byte axis = this.nodeTest.getPrimitiveType() == 2 ? (byte)2 : 3;
        Expression step = new AxisExpression(axis, this.nodeTest);
        for (int n = 0; n < this.numberOfFilters; ++n) {
            step = new FilterExpression(step, this.filters[n]);
        }
        ParentNodeExpression start = new ParentNodeExpression();
        start.setContainer(this);
        PathExpression path = new PathExpression(start, step);
        path.setContainer(this);
        return path;
    }

    public boolean matches(NodeInfo node, XPathContext context) throws XPathException {
        if (this.variableBinding != null) {
            this.variableBinding.evaluateItem(context);
        }
        return this.internalMatches(node, context);
    }

    protected boolean internalMatches(NodeInfo node, XPathContext context) throws XPathException {
        XPathContextMinor c2;
        if (!this.nodeTest.matches(node)) {
            return false;
        }
        if (this.parentPattern != null) {
            NodeInfo par = node.getParent();
            if (par == null) {
                return false;
            }
            if (!this.parentPattern.internalMatches(par, context)) {
                return false;
            }
        }
        if (this.ancestorPattern != null) {
            NodeInfo anc = node.getParent();
            while (true) {
                if (anc == null) {
                    return false;
                }
                if (this.ancestorPattern.internalMatches(anc, context)) break;
                anc = anc.getParent();
            }
        }
        if (this.specialFilter) {
            AxisIterator iter;
            if (this.firstElementPattern) {
                iter = node.iterateAxis((byte)11, this.nodeTest);
                return iter.next() == null;
            }
            if (this.lastElementPattern) {
                iter = node.iterateAxis((byte)7, this.nodeTest);
                return iter.next() == null;
            }
            if (this.equivalentExpr != null) {
                c2 = context.newMinorContext();
                c2.setOriginatingConstructType(2064);
                UnfailingIterator single = SingletonIterator.makeIterator(node);
                single.next();
                c2.setCurrentIterator(single);
                try {
                    NodeInfo n;
                    SequenceIterator nsv = this.equivalentExpr.iterate(c2);
                    do {
                        if ((n = (NodeInfo)nsv.next()) != null) continue;
                        return false;
                    } while (!n.isSameNodeInfo(node));
                    return true;
                }
                catch (XPathException e2) {
                    XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", e2);
                    err.setXPathContext(c2);
                    err.setErrorCode(e2.getErrorCodeLocalPart());
                    err.setLocator(this);
                    c2.getController().recoverableError(err);
                    return false;
                }
            }
        }
        if (this.filters != null) {
            c2 = context.newMinorContext();
            c2.setOriginatingConstructType(2064);
            UnfailingIterator iter = SingletonIterator.makeIterator(node);
            iter.next();
            c2.setCurrentIterator(iter);
            for (int i = 0; i < this.numberOfFilters; ++i) {
                try {
                    if (this.filters[i].effectiveBooleanValue(c2)) continue;
                    return false;
                }
                catch (XPathException e3) {
                    if ("XTDE0640".equals(e3.getErrorCodeLocalPart())) {
                        throw e3;
                    }
                    XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", e3);
                    err.setXPathContext(c2);
                    err.setErrorCode(e3.getErrorCodeLocalPart());
                    err.setLocator(this);
                    c2.getController().recoverableError(err);
                    return false;
                }
            }
        }
        return true;
    }

    public int getNodeKind() {
        return this.nodeTest.getPrimitiveType();
    }

    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    public NodeTest getNodeTest() {
        if (this.refinedNodeTest != null) {
            return this.refinedNodeTest;
        }
        return this.nodeTest;
    }

    private boolean isPositional(TypeHierarchy th) {
        if (this.filters == null) {
            return false;
        }
        for (int i = 0; i < this.numberOfFilters; ++i) {
            int type = this.filters[i].getItemType(th).getPrimitiveType();
            if (type == 517 || type == 515 || type == 532 || type == 516 || type == 632) {
                return true;
            }
            if ((this.filters[i].getDependencies() & 0xC) == 0) continue;
            return true;
        }
        return false;
    }

    public void resolveCurrent(LetExpression let, PromotionOffer offer, boolean topLevel) throws XPathException {
        for (int i = 0; i < this.numberOfFilters; ++i) {
            this.filters[i] = this.filters[i].promote(offer);
        }
        if (this.parentPattern instanceof LocationPathPattern) {
            ((LocationPathPattern)this.parentPattern).resolveCurrent(let, offer, false);
        }
        if (this.ancestorPattern instanceof LocationPathPattern) {
            ((LocationPathPattern)this.ancestorPattern).resolveCurrent(let, offer, false);
        }
        if (topLevel) {
            this.variableBinding = let;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof LocationPathPattern) {
            LocationPathPattern lpp = (LocationPathPattern)other;
            if (this.numberOfFilters != lpp.numberOfFilters) {
                return false;
            }
            for (int i = 0; i < this.numberOfFilters; ++i) {
                if (this.filters[i].equals(lpp.filters[i])) continue;
                return false;
            }
            if (!this.nodeTest.equals(lpp.nodeTest)) {
                return false;
            }
            if (this.parentPattern == null ? lpp.parentPattern != null : !this.parentPattern.equals(lpp.parentPattern)) {
                return false;
            }
            return !(this.ancestorPattern == null ? lpp.ancestorPattern != null : !this.ancestorPattern.equals(lpp.ancestorPattern));
        }
        return false;
    }

    public int hashCode() {
        int h2 = 88267;
        for (int i = 0; i < this.numberOfFilters; ++i) {
            h2 ^= this.filters[i].hashCode();
        }
        h2 ^= this.nodeTest.hashCode();
        if (this.parentPattern != null) {
            h2 ^= this.parentPattern.hashCode();
        }
        if (this.ancestorPattern != null) {
            h2 ^= this.ancestorPattern.hashCode();
        }
        return h2;
    }
}

