/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;

public final class KeyPattern
extends Pattern {
    private StructuredQName keyName;
    private KeyDefinitionSet keySet;
    private Expression keyExpression;

    public KeyPattern(StructuredQName keyName, Expression key) {
        this.keyName = keyName;
        this.keyExpression = key;
    }

    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.keyExpression = visitor.typeCheck(this.keyExpression, contextItemType);
        this.keySet = visitor.getExecutable().getKeyManager().getKeyDefinitionSet(this.keyName);
        return this;
    }

    public int getDependencies() {
        return this.keyExpression.getDependencies();
    }

    public Iterator iterateSubExpressions() {
        return this.keyExpression.iterateSubExpressions();
    }

    public void promote(PromotionOffer offer) throws XPathException {
        this.keyExpression = this.keyExpression.promote(offer);
    }

    public boolean matches(NodeInfo e2, XPathContext context) throws XPathException {
        DocumentInfo doc;
        KeyDefinitionSet kds = this.keySet;
        if (kds == null) {
            kds = context.getController().getExecutable().getKeyManager().getKeyDefinitionSet(this.keyName);
        }
        if ((doc = e2.getDocumentRoot()) == null) {
            return false;
        }
        KeyManager km = context.getController().getKeyManager();
        SequenceIterator iter = this.keyExpression.iterate(context);
        block0: while (true) {
            NodeInfo n;
            Item it;
            if ((it = iter.next()) == null) {
                return false;
            }
            SequenceIterator nodes = km.selectByKey(kds, doc, (AtomicValue)it, context);
            do {
                if ((n = (NodeInfo)nodes.next()) == null) continue block0;
            } while (!n.isSameNodeInfo(e2));
            break;
        }
        return true;
    }

    public NodeTest getNodeTest() {
        return AnyNodeTest.getInstance();
    }

    public boolean equals(Object other) {
        return other instanceof KeyPattern && ((KeyPattern)other).keyName.equals(this.keyName) && ((KeyPattern)other).keyExpression.equals(this.keyExpression);
    }

    public int hashCode() {
        return 0x87287310 ^ this.keyExpression.hashCode() & this.keyName.hashCode();
    }
}

