/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StrippedDocument;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public class StrippedNode
implements NodeInfo,
VirtualNode {
    protected NodeInfo node;
    protected StrippedNode parent;
    protected StrippedDocument docWrapper;

    protected StrippedNode() {
    }

    protected StrippedNode(NodeInfo node, StrippedNode parent) {
        this.node = node;
        this.parent = parent;
    }

    protected StrippedNode makeWrapper(NodeInfo node, StrippedDocument docWrapper, StrippedNode parent) {
        StrippedNode wrapper = new StrippedNode(node, parent);
        wrapper.docWrapper = docWrapper;
        return wrapper;
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public Configuration getConfiguration() {
        return this.node.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.node.getNamePool();
    }

    public int getNodeKind() {
        return this.node.getNodeKind();
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return this.node.getTypedValue();
    }

    public Value atomize() throws XPathException {
        return this.node.atomize();
    }

    public int getTypeAnnotation() {
        return this.node.getTypeAnnotation();
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (other instanceof StrippedNode) {
            return this.node.isSameNodeInfo(((StrippedNode)other).node);
        }
        return this.node.isSameNodeInfo(other);
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return ((Object)this.node).hashCode() ^ 0x3C3C3C3C;
    }

    public String getSystemId() {
        return this.node.getSystemId();
    }

    public void setSystemId(String uri) {
        this.node.setSystemId(uri);
    }

    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    public int getLineNumber() {
        return this.node.getLineNumber();
    }

    public int getColumnNumber() {
        return this.node.getColumnNumber();
    }

    public int compareOrder(NodeInfo other) {
        if (other instanceof StrippedNode) {
            return this.node.compareOrder(((StrippedNode)other).node);
        }
        return this.node.compareOrder(other);
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        switch (this.getNodeKind()) {
            case 1: 
            case 9: {
                NodeInfo it;
                AxisIterator iter = this.iterateAxis((byte)4, NodeKindTest.makeNodeKindTest(3));
                FastStringBuffer sb = new FastStringBuffer(1024);
                while ((it = (NodeInfo)iter.next()) != null) {
                    sb.append(it.getStringValueCS());
                }
                return sb.condense();
            }
        }
        return this.node.getStringValueCS();
    }

    public int getNameCode() {
        return this.node.getNameCode();
    }

    public int getFingerprint() {
        return this.node.getFingerprint();
    }

    public String getLocalPart() {
        return this.node.getLocalPart();
    }

    public String getURI() {
        return this.node.getURI();
    }

    public String getPrefix() {
        return this.node.getPrefix();
    }

    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    public NodeInfo getParent() {
        NodeInfo realParent;
        if (this.parent == null && (realParent = this.node.getParent()) != null) {
            this.parent = this.makeWrapper(realParent, this.docWrapper, null);
        }
        return this.parent;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 2: 
            case 8: {
                return new WrappingIterator(this.node.iterateAxis(axisNumber), this);
            }
            case 3: {
                return new StrippingIterator(this.node.iterateAxis(axisNumber), this);
            }
            case 7: 
            case 11: {
                StrippedNode parent = (StrippedNode)this.getParent();
                if (parent == null) {
                    return EmptyIterator.getInstance();
                }
                return new StrippingIterator(this.node.iterateAxis(axisNumber), parent);
            }
        }
        return new StrippingIterator(this.node.iterateAxis(axisNumber), null);
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        return new Navigator.AxisFilter(this.iterateAxis(axisNumber), nodeTest);
    }

    public String getAttributeValue(int fingerprint) {
        return this.node.getAttributeValue(fingerprint);
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    public void generateId(FastStringBuffer buffer) {
        this.node.generateId(buffer);
    }

    public int getDocumentNumber() {
        return this.docWrapper.getDocumentNumber();
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        Stripper stripper = this.docWrapper.getStripper().getAnother();
        stripper.setUnderlyingReceiver(out);
        this.node.copy(stripper, whichNamespaces, copyAnnotations, locationId);
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return this.node.getDeclaredNamespaces(buffer);
    }

    public boolean isId() {
        return false;
    }

    public boolean isIdref() {
        return false;
    }

    public boolean isNilled() {
        return false;
    }

    private final class StrippingIterator
    implements AxisIterator {
        AxisIterator base;
        StrippedNode parent;
        NodeInfo currentVirtualNode;
        int position;

        public StrippingIterator(AxisIterator base, StrippedNode parent) {
            this.base = base;
            this.parent = parent;
            this.position = 0;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public Item next() {
            NodeInfo nextRealNode;
            do {
                if ((nextRealNode = (NodeInfo)this.base.next()) != null) continue;
                return null;
            } while (!this.isPreserved(nextRealNode));
            this.currentVirtualNode = StrippedNode.this.makeWrapper(nextRealNode, StrippedNode.this.docWrapper, this.parent);
            ++this.position;
            return this.currentVirtualNode;
        }

        private boolean isPreserved(NodeInfo nextRealNode) {
            NodeInfo actualParent;
            if (nextRealNode.getNodeKind() != 3) {
                return true;
            }
            if (!Whitespace.isWhite(nextRealNode.getStringValueCS())) {
                return true;
            }
            NodeInfo nodeInfo = actualParent = this.parent == null ? nextRealNode.getParent() : this.parent.node;
            if (StrippedNode.this.docWrapper.containsPreserveSpace()) {
                NodeInfo p = actualParent;
                while (p.getNodeKind() == 1) {
                    String val = p.getAttributeValue(386);
                    if (val != null) {
                        if ("preserve".equals(val)) {
                            return true;
                        }
                        if ("default".equals(val)) break;
                    }
                    p = p.getParent();
                }
            }
            try {
                if (StrippedNode.this.docWrapper.getStripper().isSpacePreserving(actualParent) == 1) {
                    return true;
                }
            }
            catch (XPathException e2) {
                return true;
            }
            return false;
        }

        public Item current() {
            return this.currentVirtualNode;
        }

        public int position() {
            return this.position;
        }

        public void close() {
            this.base.close();
        }

        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.currentVirtualNode.iterateAxis(axis, test);
        }

        public Value atomize() throws XPathException {
            return this.currentVirtualNode.atomize();
        }

        public CharSequence getStringValue() {
            return this.currentVirtualNode.getStringValue();
        }

        public SequenceIterator getAnother() {
            return new StrippingIterator((AxisIterator)this.base.getAnother(), this.parent);
        }

        public int getProperties() {
            return 0;
        }
    }

    private final class WrappingIterator
    implements AxisIterator {
        AxisIterator base;
        StrippedNode parent;
        NodeInfo current;
        boolean atomizing = false;

        public WrappingIterator(AxisIterator base, StrippedNode parent) {
            this.base = base;
            this.parent = parent;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public Item next() {
            Item n = this.base.next();
            this.current = n instanceof NodeInfo && !this.atomizing ? StrippedNode.this.makeWrapper((NodeInfo)n, StrippedNode.this.docWrapper, this.parent) : (NodeInfo)n;
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.base.position();
        }

        public void close() {
            this.base.close();
        }

        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValueCS();
        }

        public SequenceIterator getAnother() {
            return new WrappingIterator((AxisIterator)this.base.getAnother(), this.parent);
        }

        public int getProperties() {
            return 0;
        }
    }
}

