/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.charcode.UTF16;
import net.sf.saxon.number.Alphanumeric;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.FastStringBuffer;

public class NumberFormatter
implements Serializable {
    private ArrayList formatTokens;
    private ArrayList punctuationTokens;
    private boolean startsWithPunctuation;

    public void prepare(String format) {
        if (format.length() == 0) {
            format = "1";
        }
        this.formatTokens = new ArrayList(10);
        this.punctuationTokens = new ArrayList(10);
        int len = format.length();
        int i = 0;
        boolean first = true;
        this.startsWithPunctuation = true;
        while (i < len) {
            int c2 = format.charAt(i);
            int t = i++;
            if (UTF16.isHighSurrogate(c2)) {
                c2 = UTF16.combinePair((char)c2, format.charAt(i));
            }
            while (NumberFormatter.isLetterOrDigit(c2) && ++i != len) {
                c2 = format.charAt(i);
                if (!UTF16.isHighSurrogate(c2)) continue;
                c2 = UTF16.combinePair((char)c2, format.charAt(++i));
            }
            if (i > t) {
                String tok = format.substring(t, i);
                this.formatTokens.add(tok);
                if (first) {
                    this.punctuationTokens.add(".");
                    this.startsWithPunctuation = false;
                    first = false;
                }
            }
            if (i == len) break;
            t = i;
            c2 = format.charAt(i);
            if (UTF16.isHighSurrogate(c2)) {
                c2 = UTF16.combinePair((char)c2, format.charAt(++i));
            }
            while (!NumberFormatter.isLetterOrDigit(c2)) {
                first = false;
                if (++i == len) break;
                c2 = format.charAt(i);
                if (!UTF16.isHighSurrogate(c2)) continue;
                c2 = UTF16.combinePair((char)c2, format.charAt(++i));
            }
            if (i <= t) continue;
            String sep = format.substring(t, i);
            this.punctuationTokens.add(sep);
        }
        if (this.formatTokens.isEmpty()) {
            this.formatTokens.add("1");
            if (this.punctuationTokens.size() == 1) {
                this.punctuationTokens.add(this.punctuationTokens.get(0));
            }
        }
    }

    private static boolean isLetterOrDigit(int c2) {
        if (c2 <= 127) {
            return c2 >= 48 && c2 <= 57 || c2 >= 65 && c2 <= 90 || c2 >= 97 && c2 <= 122;
        }
        return Alphanumeric.isAlphanumeric(c2);
    }

    public CharSequence format(List numbers, int groupSize, String groupSeparator, String letterValue, String ordinal, Numberer numberer) {
        FastStringBuffer sb = new FastStringBuffer(20);
        int num = 0;
        int tok = 0;
        if (this.startsWithPunctuation) {
            sb.append((String)this.punctuationTokens.get(tok));
        }
        while (num < numbers.size()) {
            String s;
            Object o;
            if (num > 0) {
                if (tok == 0 && this.startsWithPunctuation) {
                    sb.append(".");
                } else {
                    sb.append((String)this.punctuationTokens.get(tok));
                }
            }
            if ((o = numbers.get(num++)) instanceof Long) {
                long nr = (Long)o;
                s = numberer.format(nr, (String)this.formatTokens.get(tok), groupSize, groupSeparator, letterValue, ordinal);
            } else {
                s = o.toString();
            }
            sb.append(s);
            if (++tok != this.formatTokens.size()) continue;
            --tok;
        }
        if (this.punctuationTokens.size() > this.formatTokens.size()) {
            sb.append((String)this.punctuationTokens.get(this.punctuationTokens.size() - 1));
        }
        return sb.condense();
    }
}

