/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.value.StringValue;

public class JRegexIterator
implements RegexIterator {
    private String theString;
    private Pattern pattern;
    private Matcher matcher;
    private String current;
    private String next;
    private int position = 0;
    private int prevEnd = 0;

    public JRegexIterator(String string, Pattern pattern) {
        this.theString = string;
        this.pattern = pattern;
        this.matcher = pattern.matcher(string);
        this.next = null;
    }

    public Item next() {
        if (this.next == null && this.prevEnd >= 0) {
            if (this.matcher.find()) {
                int start = this.matcher.start();
                int end = this.matcher.end();
                if (this.prevEnd == start) {
                    this.next = null;
                    this.current = this.theString.substring(start, end);
                    this.prevEnd = end;
                } else {
                    this.current = this.theString.substring(this.prevEnd, start);
                    this.next = this.theString.substring(start, end);
                }
            } else {
                if (this.prevEnd >= this.theString.length()) {
                    this.current = null;
                    this.position = -1;
                    this.prevEnd = -1;
                    return null;
                }
                this.current = this.theString.substring(this.prevEnd);
                this.next = null;
                this.prevEnd = -1;
            }
        } else if (this.prevEnd >= 0) {
            this.current = this.next;
            this.next = null;
            this.prevEnd = this.matcher.end();
        } else {
            this.current = null;
            this.position = -1;
            return null;
        }
        ++this.position;
        return StringValue.makeStringValue(this.current);
    }

    public Item current() {
        return StringValue.makeStringValue(this.current);
    }

    public int position() {
        return this.position;
    }

    public void close() {
    }

    public SequenceIterator getAnother() {
        return new JRegexIterator(this.theString, this.pattern);
    }

    public int getProperties() {
        return 0;
    }

    public boolean isMatching() {
        return this.next == null && this.prevEnd >= 0;
    }

    public String getRegexGroup(int number) {
        if (!this.isMatching()) {
            return null;
        }
        if (number > this.matcher.groupCount() || number < 0) {
            return "";
        }
        String s = this.matcher.group(number);
        if (s == null) {
            return "";
        }
        return s;
    }

    public SequenceIterator getRegexGroupIterator() {
        int c2 = this.matcher.groupCount();
        if (c2 == 0) {
            return EmptyIterator.getInstance();
        }
        Item[] groups = new StringValue[c2];
        for (int i = 1; i <= groups.length; ++i) {
            groups[i - 1] = StringValue.makeStringValue(this.matcher.group(i));
        }
        return new ArrayIterator(groups);
    }
}

