/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GroupAdjacentIterator;
import net.sf.saxon.sort.GroupByIterator;
import net.sf.saxon.sort.GroupEndingIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.sort.GroupStartingIterator;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortKeyEvaluator;
import net.sf.saxon.sort.SortedGroupIterator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;

public class ForEachGroup
extends Instruction
implements ContextMappingFunction,
SortKeyEvaluator {
    public static final int GROUP_BY = 0;
    public static final int GROUP_ADJACENT = 1;
    public static final int GROUP_STARTING = 2;
    public static final int GROUP_ENDING = 3;
    private Expression select;
    private Expression action;
    private byte algorithm;
    private Expression key;
    private Expression collationNameExpression;
    private String baseURI;
    private StringCollator collator = null;
    private SortKeyDefinition[] sortKeys = null;
    private transient AtomicComparer[] sortComparators = null;

    public ForEachGroup(Expression select, Expression action, byte algorithm, Expression key, StringCollator collator, Expression collationNameExpression, String baseURI, SortKeyDefinition[] sortKeys) {
        this.select = select;
        this.action = action;
        this.algorithm = algorithm;
        this.key = key;
        this.collator = collator;
        this.collationNameExpression = collationNameExpression;
        this.baseURI = baseURI;
        this.sortKeys = sortKeys;
        Iterator kids = this.iterateSubExpressions();
        while (kids.hasNext()) {
            Expression child = (Expression)kids.next();
            this.adoptChildExpression(child);
        }
    }

    public int getInstructionNameCode() {
        return 148;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public Expression getGroupingKey() {
        return this.key;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.action = visitor.simplify(this.action);
        this.key = visitor.simplify(this.key);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.typeCheck(this.select, contextItemType);
        ItemType selectedItemType = this.select.getItemType(th);
        this.action = visitor.typeCheck(this.action, selectedItemType);
        this.key = visitor.typeCheck(this.key, selectedItemType);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        if (this.sortKeys != null) {
            int i;
            boolean allFixed = true;
            for (i = 0; i < this.sortKeys.length; ++i) {
                Expression sortKey = this.sortKeys[i].getSortKey();
                sortKey = visitor.typeCheck(sortKey, selectedItemType);
                if (visitor.getStaticContext().isInBackwardsCompatibleMode()) {
                    sortKey = new FirstItemExpression(sortKey);
                } else {
                    RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:sort/select"), 0);
                    role.setErrorCode("XTTE1020");
                    sortKey = CardinalityChecker.makeCardinalityChecker(sortKey, 24576, role);
                }
                this.sortKeys[i].setSortKey(sortKey);
                if (this.sortKeys[i].isFixed()) {
                    AtomicComparer comp = this.sortKeys[i].makeComparator(visitor.getStaticContext().makeEarlyEvaluationContext());
                    this.sortKeys[i].setFinalComparator(comp);
                    continue;
                }
                allFixed = false;
            }
            if (allFixed) {
                this.sortComparators = new AtomicComparer[this.sortKeys.length];
                for (i = 0; i < this.sortKeys.length; ++i) {
                    this.sortComparators[i] = this.sortKeys[i].getFinalComparator();
                }
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.optimize(this.select, contextItemType);
        this.action = this.action.optimize(visitor, this.select.getItemType(th));
        this.key = this.key.optimize(visitor, this.select.getItemType(th));
        this.adoptChildExpression(this.select);
        this.adoptChildExpression(this.action);
        this.adoptChildExpression(this.key);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        ItemType selectedItemType = this.select.getItemType(th);
        if (this.sortKeys != null) {
            for (int i = 0; i < this.sortKeys.length; ++i) {
                Expression sortKey = this.sortKeys[i].getSortKey();
                sortKey = visitor.optimize(sortKey, selectedItemType);
                this.sortKeys[i].setSortKey(sortKey);
            }
        }
        if (this.collator == null && this.collationNameExpression instanceof StringLiteral) {
            String collation = ((StringLiteral)this.collationNameExpression).getStringValue();
            try {
                URI collationURI = new URI(collation);
                if (!collationURI.isAbsolute()) {
                    URI base = new URI(this.baseURI);
                    collationURI = base.resolve(collationURI);
                    String collationNameString = collationURI.toString();
                    this.collationNameExpression = new StringLiteral(collationNameString);
                    this.collator = visitor.getStaticContext().getCollation(collationNameString);
                    if (this.collator == null) {
                        XPathException err = new XPathException("Unknown collation " + Err.wrap(collationURI.toString(), 7));
                        err.setErrorCode("XTDE1110");
                        err.setLocator(this);
                        throw err;
                    }
                }
            }
            catch (URISyntaxException err) {
                XPathException e2 = new XPathException("Collation name '" + this.collationNameExpression + "' is not a valid URI");
                e2.setErrorCode("XTDE1110");
                e2.setLocator(this);
                throw e2;
            }
        }
        return this;
    }

    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.action.getItemType(th);
    }

    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.select.getDependencies();
        dependencies |= this.key.getDependencies() & 0xFFFFFFE1;
        dependencies |= this.action.getDependencies() & 0xFFFFFFC1;
        if (this.sortKeys != null) {
            for (int i = 0; i < this.sortKeys.length; ++i) {
                dependencies |= this.sortKeys[i].getSortKey().getDependencies() & 0xFFFFFFE1;
                Expression e2 = this.sortKeys[i].getCaseOrder();
                if (e2 != null && !(e2 instanceof Literal)) {
                    dependencies |= e2.getDependencies();
                }
                if ((e2 = this.sortKeys[i].getDataTypeExpression()) != null && !(e2 instanceof Literal)) {
                    dependencies |= e2.getDependencies();
                }
                if ((e2 = this.sortKeys[i].getLanguage()) == null || e2 instanceof Literal) continue;
                dependencies |= e2.getDependencies();
            }
        }
        if (this.collationNameExpression != null) {
            dependencies |= this.collationNameExpression.getDependencies();
        }
        return dependencies;
    }

    public final boolean createsNewNodes() {
        int props = this.action.getSpecialProperties();
        return (props & 0x400000) == 0;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        this.action = this.doPromotion(this.action, offer);
        this.key = this.doPromotion(this.key, offer);
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(8);
        list.add(this.select);
        list.add(this.action);
        list.add(this.key);
        if (this.collationNameExpression != null) {
            list.add(this.collationNameExpression);
        }
        if (this.sortKeys != null) {
            for (int i = 0; i < this.sortKeys.length; ++i) {
                list.add(this.sortKeys[i].getSortKey());
                Expression e2 = this.sortKeys[i].getOrder();
                if (e2 != null) {
                    list.add(e2);
                }
                if ((e2 = this.sortKeys[i].getCaseOrder()) != null) {
                    list.add(e2);
                }
                if ((e2 = this.sortKeys[i].getDataTypeExpression()) != null) {
                    list.add(e2);
                }
                if ((e2 = this.sortKeys[i].getLanguage()) != null) {
                    list.add(e2);
                }
                if ((e2 = this.sortKeys[i].getCollationNameExpression()) == null) continue;
                list.add(e2);
            }
        }
        return list.iterator();
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.select.addToPathMap(pathMap, pathMapNodeSet);
        if (this.collationNameExpression != null) {
            this.collationNameExpression.addToPathMap(pathMap, pathMapNodeSet);
        }
        if (this.sortKeys != null) {
            for (int i = 0; i < this.sortKeys.length; ++i) {
                this.sortKeys[i].getSortKey().addToPathMap(pathMap, target);
                Expression e2 = this.sortKeys[i].getOrder();
                if (e2 != null) {
                    e2.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e2 = this.sortKeys[i].getCaseOrder()) != null) {
                    e2.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e2 = this.sortKeys[i].getDataTypeExpression()) != null) {
                    e2.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e2 = this.sortKeys[i].getLanguage()) != null) {
                    e2.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e2 = this.sortKeys[i].getCollationNameExpression()) == null) continue;
                e2.addToPathMap(pathMap, pathMapNodeSet);
            }
        }
        return this.action.addToPathMap(pathMap, target);
    }

    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.action || child == this.key;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        if (this.collationNameExpression == original) {
            this.collationNameExpression = replacement;
            found = true;
        }
        if (this.key == original) {
            this.key = replacement;
            found = true;
        }
        if (this.sortKeys != null) {
            for (int i = 0; i < this.sortKeys.length; ++i) {
                if (this.sortKeys[i].getSortKey() == original) {
                    this.sortKeys[i].setSortKey(replacement);
                    found = true;
                }
                if (this.sortKeys[i].getOrder() == original) {
                    this.sortKeys[i].setOrder(replacement);
                    found = true;
                }
                if (this.sortKeys[i].getCaseOrder() == original) {
                    this.sortKeys[i].setCaseOrder(replacement);
                    found = true;
                }
                if (this.sortKeys[i].getDataTypeExpression() == original) {
                    this.sortKeys[i].setDataTypeExpression(replacement);
                    found = true;
                }
                if (this.sortKeys[i].getLanguage() != original) continue;
                this.sortKeys[i].setLanguage(replacement);
                found = true;
            }
        }
        return found;
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        this.action.checkPermittedContents(parentType, env, false);
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        GroupIterator groupIterator = this.getGroupIterator(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(groupIterator);
        c2.setCurrentGroupIterator(groupIterator);
        c2.setCurrentTemplateRule(null);
        if (controller.isTracing()) {
            Item item;
            TraceListener listener = controller.getTraceListener();
            while ((item = groupIterator.next()) != null) {
                listener.startCurrentItem(item);
                this.action.process(c2);
                listener.endCurrentItem(item);
            }
        } else {
            Item item;
            while ((item = groupIterator.next()) != null) {
                this.action.process(c2);
            }
        }
        return null;
    }

    private StringCollator getCollator(XPathContext context) throws XPathException {
        if (this.collationNameExpression != null) {
            StringValue collationValue = (StringValue)this.collationNameExpression.evaluateItem(context);
            String cname = collationValue.getStringValue();
            try {
                URI collationURI = new URI(cname);
                if (!collationURI.isAbsolute()) {
                    if (this.baseURI == null) {
                        XPathException err = new XPathException("Cannot resolve relative collation URI '" + cname + "': unknown or invalid base URI");
                        err.setErrorCode("XTDE1110");
                        err.setXPathContext(context);
                        err.setLocator(this);
                        throw err;
                    }
                    collationURI = new URI(this.baseURI).resolve(collationURI);
                    cname = collationURI.toString();
                }
            }
            catch (URISyntaxException e2) {
                XPathException err = new XPathException("Collation name '" + cname + "' is not a valid URI");
                err.setErrorCode("XTDE1110");
                err.setXPathContext(context);
                err.setLocator(this);
                throw err;
            }
            return context.getCollation(cname);
        }
        StringCollator collator = context.getDefaultCollation();
        return collator == null ? CodepointCollator.getInstance() : collator;
    }

    private GroupIterator getGroupIterator(XPathContext context) throws XPathException {
        GroupIterator groupIterator;
        SequenceIterator population = this.select.iterate(context);
        switch (this.algorithm) {
            case 0: {
                StringCollator coll = this.collator;
                if (coll == null) {
                    coll = this.getCollator(context);
                }
                XPathContextMinor c2 = context.newMinorContext();
                c2.setOrigin(this);
                c2.setCurrentIterator(population);
                groupIterator = new GroupByIterator(population, this.key, c2, coll);
                break;
            }
            case 1: {
                StringCollator coll = this.collator;
                if (coll == null) {
                    coll = this.getCollator(context);
                }
                groupIterator = new GroupAdjacentIterator(population, this.key, context, coll);
                break;
            }
            case 2: {
                groupIterator = new GroupStartingIterator(population, ((PatternSponsor)this.key).getPattern(), context);
                break;
            }
            case 3: {
                groupIterator = new GroupEndingIterator(population, ((PatternSponsor)this.key).getPattern(), context);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown grouping algorithm");
            }
        }
        if (this.sortKeys != null) {
            AtomicComparer[] comps = this.sortComparators;
            XPathContextMinor xpc = context.newMinorContext();
            if (comps == null) {
                comps = new AtomicComparer[this.sortKeys.length];
                for (int s = 0; s < this.sortKeys.length; ++s) {
                    comps[s] = this.sortKeys[s].makeComparator(xpc);
                }
            }
            groupIterator = new SortedGroupIterator(xpc, groupIterator, this, comps, this);
        }
        return groupIterator;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        GroupIterator master = this.getGroupIterator(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(master);
        c2.setCurrentGroupIterator(master);
        c2.setCurrentTemplateRule(null);
        return new ContextMappingIterator(this, c2);
    }

    public SequenceIterator map(XPathContext context) throws XPathException {
        return this.action.iterate(context);
    }

    public Item evaluateSortKey(int n, XPathContext c2) throws XPathException {
        return this.sortKeys[n].getSortKey().evaluateItem(c2);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("forEachGroup");
        out.emitAttribute("algorithm", this.getAlgorithmName(this.algorithm));
        out.startSubsidiaryElement("select");
        this.select.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("key");
        this.key.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("return");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }

    private String getAlgorithmName(byte algorithm) {
        switch (algorithm) {
            case 0: {
                return "group-by";
            }
            case 1: {
                return "group-adjacent";
            }
            case 2: {
                return "group-starting-with";
            }
            case 3: {
                return "group-ending-with";
            }
        }
        return "** unknown algorithm **";
    }
}

