/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.Validation;
import net.sf.saxon.om.VirtualCopy;
import net.sf.saxon.om.VirtualUntypedCopy;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

public class CopyOf
extends Instruction {
    private Expression select;
    private boolean copyNamespaces;
    private int validation;
    private SchemaType schemaType;
    private boolean requireDocumentOrElement = false;
    private boolean rejectDuplicateAttributes;
    private boolean readOnce = false;
    private boolean validating;
    private boolean copyLineNumbers = true;
    private boolean copyForUpdate = false;
    private String staticBaseUri;

    public CopyOf(Expression select, boolean copyNamespaces, int validation, SchemaType schemaType, boolean rejectDuplicateAttributes) {
        this.select = select;
        this.copyNamespaces = copyNamespaces;
        this.validation = validation;
        this.schemaType = schemaType;
        this.validating = schemaType != null || validation != 3;
        this.rejectDuplicateAttributes = rejectDuplicateAttributes;
        this.adoptChildExpression(select);
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public int getValidationMode() {
        return this.validation;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setStaticBaseUri(String base) {
        this.staticBaseUri = base;
    }

    public void setReadOnce(boolean b2) {
        this.readOnce = b2;
    }

    public void setCopyLineNumbers(boolean copy) {
        this.copyLineNumbers = copy;
    }

    public final boolean createsNewNodes() {
        Executable exec = this.getExecutable();
        if (exec == null) {
            return true;
        }
        TypeHierarchy th = exec.getConfiguration().getTypeHierarchy();
        return !this.select.getItemType(th).isAtomicType();
    }

    public int getInstructionNameCode() {
        return 140;
    }

    public void setRequireDocumentOrElement(boolean requireDocumentOrElement) {
        this.requireDocumentOrElement = requireDocumentOrElement;
    }

    public boolean isDocumentOrElementRequired() {
        return this.requireDocumentOrElement;
    }

    public void setCopyForUpdate(boolean forUpdate) {
        this.copyForUpdate = forUpdate;
    }

    public boolean isCopyForUpdate() {
        return this.copyForUpdate;
    }

    public int getImplementationMethod() {
        return 6;
    }

    public boolean isCopyNamespaces() {
        return this.copyNamespaces;
    }

    public Expression copy() {
        CopyOf c2 = new CopyOf(this.select.copy(), this.copyNamespaces, this.validation, this.schemaType, this.rejectDuplicateAttributes);
        c2.setContainer(this.getContainer());
        c2.setCopyForUpdate(this.copyForUpdate);
        c2.setCopyLineNumbers(this.copyLineNumbers);
        c2.setReadOnce(this.readOnce);
        c2.setStaticBaseUri(this.staticBaseUri);
        return c2;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.schemaType != null) {
            Configuration config = this.getExecutable().getConfiguration();
            ItemType in = this.select.getItemType(th);
            int e2 = th.relationship(in, NodeKindTest.ELEMENT);
            if (e2 == 0 || e2 == 2) {
                return new ContentTypeTest(1, this.schemaType, config);
            }
            int a2 = th.relationship(in, NodeKindTest.ATTRIBUTE);
            if (a2 == 0 || a2 == 2) {
                return new ContentTypeTest(2, this.schemaType, config);
            }
        }
        return this.select.getItemType(th);
    }

    public int getCardinality() {
        return this.select.getCardinality();
    }

    public int getDependencies() {
        return this.select.getDependencies();
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.select = visitor.typeCheck(this.select, contextItemType);
        if (this.isDocumentOrElementRequired()) {
            ItemType t;
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType(t = this.select.getItemType(th), NodeKindTest.ATTRIBUTE)) {
                throw new XPathException("validate{} expression cannot be applied to an attribute", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.TEXT)) {
                throw new XPathException("validate{} expression cannot be applied to a text node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.COMMENT)) {
                throw new XPathException("validate{} expression cannot be applied to a comment node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.PROCESSING_INSTRUCTION)) {
                throw new XPathException("validate{} expression cannot be applied to a processing instruction node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.NAMESPACE)) {
                throw new XPathException("validate{} expression cannot be applied to a namespace node", "XQTY0030");
            }
        }
        this.adoptChildExpression(this.select);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression optcopy;
        if (this.readOnce && (optcopy = visitor.getConfiguration().getOptimizer().optimizeCopy(this.select)) != null) {
            return optcopy;
        }
        this.select = visitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.select.getItemType(th).isAtomicType()) {
            return this.select;
        }
        return this;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("copyOf");
        out.emitAttribute("validation", Validation.toString(this.validation));
        this.select.explain(out);
        out.endElement();
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.select);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        return found;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Item item;
        Controller controller = context.getController();
        SequenceReceiver out = context.getReceiver();
        boolean copyBaseURI = out.getSystemId() == null;
        int whichNamespaces = this.copyNamespaces ? 2 : 0;
        SequenceIterator iter = this.select.iterate(context);
        block17: while ((item = iter.next()) != null) {
            if (item instanceof NodeInfo) {
                NodeInfo source = (NodeInfo)item;
                int kind = source.getNodeKind();
                if (this.requireDocumentOrElement && kind != 1 && kind != 9) {
                    XPathException e2 = new XPathException("Operand of validate expression must be a document or element node");
                    e2.setXPathContext(context);
                    e2.setErrorCode("XQTY0030");
                    throw e2;
                }
                switch (kind) {
                    case 1: {
                        LocationCopier copier;
                        SequenceReceiver eval = out;
                        if (this.validating) {
                            eval = controller.getConfiguration().getElementValidator(out, source.getNameCode(), this.locationId, this.schemaType, this.validation);
                        }
                        if (copyBaseURI) {
                            eval.setSystemId(this.computeNewBaseUri(source));
                        }
                        Receiver savedReceiver = null;
                        PipelineConfiguration savedPipe = null;
                        if (this.copyLineNumbers) {
                            savedReceiver = eval;
                            savedPipe = new PipelineConfiguration(eval.getPipelineConfiguration());
                            copier = new LocationCopier(eval);
                            eval.getPipelineConfiguration().setLocationProvider(copier);
                            eval = copier;
                        }
                        try {
                            source.copy(eval, whichNamespaces, true, this.locationId);
                        }
                        catch (CopyNamespaceSensitiveException e3) {
                            e3.setErrorCode(this.getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086");
                            throw e3;
                        }
                        if (!this.copyLineNumbers) continue block17;
                        eval = savedReceiver;
                        eval.setPipelineConfiguration(savedPipe);
                        break;
                    }
                    case 2: {
                        XPathException e4;
                        try {
                            CopyOf.copyAttribute(source, this.schemaType, this.validation, this, context, this.rejectDuplicateAttributes);
                            break;
                        }
                        catch (NoOpenStartTagException err) {
                            e4 = new XPathException(err.getMessage());
                            e4.setLocator(this);
                            e4.setXPathContext(context);
                            e4.setErrorCode(err.getErrorCodeLocalPart());
                            throw CopyOf.dynamicError(this, e4, context);
                        }
                    }
                    case 3: {
                        out.characters(source.getStringValueCS(), this.locationId, 0);
                        break;
                    }
                    case 7: {
                        if (copyBaseURI) {
                            out.setSystemId(source.getBaseURI());
                        }
                        out.processingInstruction(source.getDisplayName(), source.getStringValueCS(), this.locationId, 0);
                        break;
                    }
                    case 8: {
                        out.comment(source.getStringValueCS(), this.locationId, 0);
                        break;
                    }
                    case 13: {
                        XPathException e4;
                        try {
                            source.copy(out, 0, false, this.locationId);
                            break;
                        }
                        catch (NoOpenStartTagException err) {
                            e4 = new XPathException(err.getMessage());
                            e4.setXPathContext(context);
                            e4.setErrorCode(err.getErrorCodeLocalPart());
                            throw CopyOf.dynamicError(this, e4, context);
                        }
                    }
                    case 9: {
                        LocationCopier copier;
                        Receiver val = controller.getConfiguration().getDocumentValidator(out, source.getBaseURI(), this.validation, 0, this.schemaType, -1);
                        val.setPipelineConfiguration(out.getPipelineConfiguration());
                        if (copyBaseURI) {
                            val.setSystemId(source.getBaseURI());
                        }
                        Receiver savedReceiver = null;
                        PipelineConfiguration savedPipe = null;
                        if (this.copyLineNumbers) {
                            savedReceiver = val;
                            savedPipe = new PipelineConfiguration(val.getPipelineConfiguration());
                            copier = new LocationCopier(val);
                            val.getPipelineConfiguration().setLocationProvider(copier);
                            val = copier;
                        }
                        try {
                            source.copy(val, whichNamespaces, true, this.locationId);
                        }
                        catch (CopyNamespaceSensitiveException e5) {
                            e5.setErrorCode(this.getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086");
                            throw e5;
                        }
                        if (!this.copyLineNumbers) continue block17;
                        val = savedReceiver;
                        val.setPipelineConfiguration(savedPipe);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown node kind " + source.getNodeKind());
                    }
                }
                continue;
            }
            out.append(item, this.locationId, 2);
        }
        return null;
    }

    private String computeNewBaseUri(NodeInfo source) {
        String newBaseUri;
        block6: {
            String xmlBase = source.getAttributeValue(385);
            if (xmlBase != null) {
                try {
                    URI xmlBaseUri = new URI(xmlBase);
                    if (xmlBaseUri.isAbsolute()) {
                        newBaseUri = xmlBase;
                        break block6;
                    }
                    if (this.staticBaseUri != null) {
                        URI sbu = new URI(this.staticBaseUri);
                        URI abs = sbu.resolve(xmlBaseUri);
                        newBaseUri = abs.toString();
                        break block6;
                    }
                    newBaseUri = source.getBaseURI();
                }
                catch (URISyntaxException err) {
                    newBaseUri = source.getBaseURI();
                }
            } else {
                newBaseUri = source.getBaseURI();
            }
        }
        return newBaseUri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void copyAttribute(NodeInfo source, SchemaType schemaType, int validation, Instruction instruction, XPathContext context, boolean rejectDuplicates) throws XPathException {
        SchemaType type;
        int nameCode = source.getNameCode();
        int annotation = 631;
        int opt = 0;
        if (rejectDuplicates) {
            opt |= 0x20;
        }
        CharSequence value = source.getStringValueCS();
        if (schemaType != null) {
            if (!schemaType.isSimpleType()) {
                XPathException e2 = new XPathException("Cannot validate an attribute against a complex type");
                e2.setXPathContext(context);
                e2.setErrorCode("XTSE1530");
                e2.setIsStaticError(true);
                throw e2;
            }
            if (((SimpleType)schemaType).isNamespaceSensitive()) {
                XPathException err = new XPathException("Cannot create a parentless attribute whose type is namespace-sensitive (such as xs:QName)");
                err.setErrorCode("XTTE1545");
                err.setXPathContext(context);
                err.setLocator(instruction);
                throw err;
            }
            try {
                ValidationFailure err = ((SimpleType)schemaType).validateContent(value, DummyNamespaceResolver.getInstance(), context.getConfiguration().getNameChecker());
                if (err != null) {
                    throw new ValidationException("Attribute being copied does not match the required type. " + err.getMessage());
                }
                annotation = schemaType.getFingerprint();
            }
            catch (UnresolvedReferenceException ure) {
                throw new ValidationException(ure);
            }
        } else if (validation == 1 || validation == 2) {
            try {
                annotation = context.getConfiguration().validateAttribute(nameCode, value, validation);
            }
            catch (ValidationException e3) {
                XPathException err = XPathException.makeXPathException(e3);
                err.setErrorCode(e3.getErrorCodeLocalPart());
                err.setXPathContext(context);
                err.setLocator(instruction);
                err.setIsTypeError(true);
                throw err;
            }
        } else if (validation == 3 && (annotation = source.getTypeAnnotation() & 0xFFFFF) != 631 && ((AtomicType)(type = context.getConfiguration().getSchemaType(annotation))).isNamespaceSensitive()) {
            XPathException err = new XPathException("Cannot preserve type annotation when copying an attribute with namespace-sensitive content");
            err.setErrorCode("XTTE0950");
            err.setIsTypeError(true);
            err.setXPathContext(context);
            throw err;
        }
        context.getReceiver().attribute(nameCode, annotation, value, instruction.getLocationId(), opt);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return super.evaluateItem(context);
    }

    public SequenceIterator iterate(final XPathContext context) throws XPathException {
        if (this.schemaType == null && this.copyNamespaces && !this.copyForUpdate) {
            if (this.validation == 3) {
                ItemMappingFunction copier = new ItemMappingFunction(){

                    public Item map(Item item) {
                        if (item instanceof AtomicValue) {
                            return item;
                        }
                        VirtualCopy vc = VirtualCopy.makeVirtualCopy((NodeInfo)item, (NodeInfo)item);
                        int documentNumber = context.getController().getConfiguration().getDocumentNumberAllocator().allocateDocumentNumber();
                        vc.setDocumentNumber(documentNumber);
                        if (((NodeInfo)item).getNodeKind() == 1) {
                            vc.setSystemId(CopyOf.this.computeNewBaseUri((NodeInfo)item));
                        }
                        return vc;
                    }
                };
                return new ItemMappingIterator(this.select.iterate(context), copier);
            }
            if (this.validation == 4) {
                ItemMappingFunction copier = new ItemMappingFunction(){

                    public Item map(Item item) {
                        if (item instanceof AtomicValue) {
                            return item;
                        }
                        VirtualCopy vc = VirtualUntypedCopy.makeVirtualUntypedCopy((NodeInfo)item, (NodeInfo)item);
                        int documentNumber = context.getController().getConfiguration().getDocumentNumberAllocator().allocateDocumentNumber();
                        vc.setDocumentNumber(documentNumber);
                        if (((NodeInfo)item).getNodeKind() == 1) {
                            vc.setSystemId(CopyOf.this.computeNewBaseUri((NodeInfo)item));
                        }
                        return vc;
                    }
                };
                return new ItemMappingIterator(this.select.iterate(context), copier);
            }
        }
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter out = new SequenceOutputter();
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getHostLanguage());
        out.setPipelineConfiguration(pipe);
        c2.setReceiver(out);
        try {
            this.process(c2);
            return Value.getIterator(out.getSequence());
        }
        catch (XPathException err) {
            if (err instanceof ValidationException) {
                ((ValidationException)err).setSourceLocator(this);
                ((ValidationException)err).setSystemId(this.getSystemId());
            }
            err.maybeSetLocation(this);
            throw err;
        }
    }
}

