/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceCodeIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;

public class Copy
extends ElementCreator {
    private boolean copyNamespaces;
    private ItemType contextItemType;

    public Copy(boolean copyNamespaces, boolean inheritNamespaces, SchemaType schemaType, int validation) {
        this.copyNamespaces = copyNamespaces;
        this.inheritNamespaces = inheritNamespaces;
        this.setSchemaType(schemaType);
        this.validation = validation;
        boolean bl = this.preservingTypes = schemaType == null && validation == 3;
        if (copyNamespaces) {
            this.setLazyConstruction(false);
        }
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.preservingTypes |= !visitor.getConfiguration().isSchemaAware(52);
        return super.simplify(visitor);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (contextItemType instanceof NodeTest) {
            switch (contextItemType.getPrimitiveType()) {
                case 1: {
                    this.contextItemType = NodeKindTest.ELEMENT;
                    break;
                }
                case 2: {
                    this.contextItemType = NodeKindTest.ATTRIBUTE;
                    break;
                }
                case 9: {
                    this.contextItemType = NodeKindTest.DOCUMENT;
                    break;
                }
                default: {
                    this.contextItemType = contextItemType;
                    break;
                }
            }
        } else {
            this.contextItemType = contextItemType;
        }
        return super.typeCheck(visitor, contextItemType);
    }

    public Expression copy() {
        Copy copy = new Copy(this.copyNamespaces, this.inheritNamespaces, this.getSchemaType(), this.validation);
        copy.setContentExpression(this.content.copy());
        return copy;
    }

    public int getInstructionNameCode() {
        return 139;
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.contextItemType == null) {
            return AnyItemType.getInstance();
        }
        return this.contextItemType;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp == this && contextItemType.isAtomicType()) {
            return new ContextItemExpression();
        }
        return exp;
    }

    public int getNameCode(XPathContext context) throws XPathException {
        return ((NodeInfo)context.getContextItem()).getNameCode();
    }

    public String getNewBaseURI(XPathContext context) {
        return ((NodeInfo)context.getContextItem()).getBaseURI();
    }

    protected void outputNamespaceNodes(XPathContext context, Receiver receiver) throws XPathException {
        if (this.copyNamespaces) {
            NodeInfo element = (NodeInfo)context.getContextItem();
            NamespaceCodeIterator.sendNamespaces(element, receiver);
        }
    }

    public int[] getActiveNamespaces() throws XPathException {
        if (this.copyNamespaces) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        XPathContext c2 = context;
        SequenceReceiver out = c2.getReceiver();
        Item item = context.getContextItem();
        if (!(item instanceof NodeInfo)) {
            out.append(item, this.locationId, 2);
            return null;
        }
        NodeInfo source = (NodeInfo)item;
        switch (source.getNodeKind()) {
            case 1: {
                return super.processLeavingTail(c2);
            }
            case 2: {
                try {
                    CopyOf.copyAttribute(source, this.getSchemaType(), this.validation, this, c2, false);
                    break;
                }
                catch (NoOpenStartTagException err) {
                    err.setXPathContext(context);
                    throw Copy.dynamicError(this, err, c2);
                }
            }
            case 3: {
                out.characters(source.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 7: {
                out.processingInstruction(source.getDisplayName(), source.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 8: {
                out.comment(source.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 13: {
                try {
                    source.copy(out, 0, false, this.locationId);
                    break;
                }
                catch (NoOpenStartTagException err) {
                    XPathException e2 = new XPathException(err.getMessage());
                    e2.setXPathContext(context);
                    e2.setErrorCode(err.getErrorCodeLocalPart());
                    throw Copy.dynamicError(this, e2, context);
                }
            }
            case 9: {
                Receiver val;
                if (!this.preservingTypes && (val = controller.getConfiguration().getDocumentValidator(out, source.getBaseURI(), this.validation, 0, this.getSchemaType(), -1)) != out) {
                    TreeReceiver sr = new TreeReceiver(val);
                    ((SequenceReceiver)sr).setPipelineConfiguration(out.getPipelineConfiguration());
                    c2.setReceiver(sr);
                    out = sr;
                }
                out.startDocument(0);
                this.content.process(c2);
                out.endDocument();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node kind " + source.getNodeKind());
            }
        }
        return null;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter seq = controller.allocateSequenceOutputter(1);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getHostLanguage());
        seq.setPipelineConfiguration(pipe);
        c2.setTemporaryReceiver(seq);
        this.process(c2);
        seq.close();
        Item item = seq.getFirstItem();
        seq.reset();
        return item;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("copy");
        this.content.explain(out);
        out.endElement();
    }
}

