/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.evpull.BlockEventIterator;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.BlockIterator;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;

public class Block
extends Instruction {
    private Expression[] children;

    public static Expression makeBlock(Expression e1, Expression e2) {
        if (e1 == null || Literal.isEmptySequence(e1)) {
            return e2;
        }
        if (e2 == null || Literal.isEmptySequence(e2)) {
            return e1;
        }
        if (e1 instanceof Block || e2 instanceof Block) {
            Iterator it1 = e1 instanceof Block ? e1.iterateSubExpressions() : new MonoIterator(e1);
            Iterator it2 = e2 instanceof Block ? e2.iterateSubExpressions() : new MonoIterator(e2);
            ArrayList list = new ArrayList(10);
            while (it1.hasNext()) {
                list.add(it1.next());
            }
            while (it2.hasNext()) {
                list.add(it2.next());
            }
            Expression[] exps = new Expression[list.size()];
            exps = list.toArray(exps);
            Block b2 = new Block();
            b2.setChildren(exps);
            return b2;
        }
        Expression[] exps = new Expression[]{e1, e2};
        Block b3 = new Block();
        b3.setChildren(exps);
        return b3;
    }

    public static Expression makeBlock(List list) {
        Expression[] exps = new Expression[list.size()];
        exps = list.toArray(exps);
        Block b2 = new Block();
        b2.setChildren(exps);
        return b2;
    }

    public void setChildren(Expression[] children) {
        if (children == null || children.length == 0) {
            this.children = null;
        } else {
            this.children = children;
            for (int c2 = 0; c2 < children.length; ++c2) {
                this.adoptChildExpression(children[c2]);
            }
        }
    }

    public Expression[] getChildren() {
        return this.children;
    }

    public int computeSpecialProperties() {
        if (this.children == null || this.children.length == 0) {
            return 0x2FF0000;
        }
        int p = super.computeSpecialProperties();
        boolean allAxisExpressions = true;
        boolean allChildAxis = true;
        boolean allSubtreeAxis = true;
        for (int i = 0; i < this.children.length; ++i) {
            if (!(this.children[i] instanceof AxisExpression)) {
                allAxisExpressions = false;
                allChildAxis = false;
                allSubtreeAxis = false;
                break;
            }
            byte axis = ((AxisExpression)this.children[i]).getAxis();
            if (axis != 3) {
                allChildAxis = false;
            }
            if (Axis.isSubtreeAxis[axis]) continue;
            allSubtreeAxis = false;
        }
        if (allAxisExpressions) {
            p |= 0xC10000;
            if (allChildAxis) {
                p |= 0x80000;
            }
            if (allSubtreeAxis) {
                p |= 0x100000;
            }
            if (this.children.length == 2 && ((AxisExpression)this.children[0]).getAxis() == 2 && ((AxisExpression)this.children[1]).getAxis() == 3) {
                p |= 0x20000;
            }
        }
        return p;
    }

    public Expression mergeAdjacentTextInstructions() {
        boolean[] isLiteralText = new boolean[this.children.length];
        boolean hasAdjacentTextNodes = false;
        for (int i = 0; i < this.children.length; ++i) {
            boolean bl = isLiteralText[i] = this.children[i] instanceof ValueOf && ((ValueOf)this.children[i]).getSelect() instanceof StringLiteral && !((ValueOf)this.children[i]).isDisableOutputEscaping();
            if (i <= 0 || !isLiteralText[i] || !isLiteralText[i - 1]) continue;
            hasAdjacentTextNodes = true;
        }
        if (hasAdjacentTextNodes) {
            ArrayList<Expression> content = new ArrayList<Expression>(this.children.length);
            String pendingText = null;
            for (int i = 0; i < this.children.length; ++i) {
                if (isLiteralText[i]) {
                    pendingText = (pendingText == null ? "" : pendingText) + ((StringLiteral)((ValueOf)this.children[i]).getSelect()).getStringValue();
                    continue;
                }
                if (pendingText != null) {
                    ValueOf inst = new ValueOf(new StringLiteral(pendingText), false, false);
                    content.add(inst);
                    pendingText = null;
                }
                content.add(this.children[i]);
            }
            if (pendingText != null) {
                ValueOf inst = new ValueOf(new StringLiteral(pendingText), false, false);
                content.add(inst);
            }
            return Block.makeBlock(content);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        if (this.children == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Arrays.asList(this.children).iterator();
    }

    public boolean containsLocalParam() {
        return this.children != null && this.children.length > 0 && this.children[0] instanceof LocalParam;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int c2 = 0; c2 < this.children.length; ++c2) {
            if (this.children[c2] != original) continue;
            this.children[c2] = replacement;
            found = true;
        }
        return found;
    }

    public Expression copy() {
        Expression[] c2 = new Expression[this.children.length];
        for (int c3 = 0; c3 < this.children.length; ++c3) {
            c2[c3] = this.children[c3].copy();
        }
        Block b2 = new Block();
        b2.children = c2;
        return b2;
    }

    public final ItemType getItemType(TypeHierarchy th) {
        if (this.children == null || this.children.length == 0) {
            return EmptySequenceTest.getInstance();
        }
        ItemType t1 = this.children[0].getItemType(th);
        for (int i = 1; i < this.children.length; ++i) {
            if (!((t1 = Type.getCommonSuperType(t1, this.children[i].getItemType(th), th)) instanceof AnyItemType)) continue;
            return t1;
        }
        return t1;
    }

    public final int getCardinality() {
        if (this.children == null || this.children.length == 0) {
            return 8192;
        }
        int c1 = this.children[0].getCardinality();
        for (int i = 1; i < this.children.length && (c1 = Cardinality.sum(c1, this.children[i].getCardinality())) != 57344; ++i) {
        }
        return c1;
    }

    public final boolean createsNewNodes() {
        if (this.children == null) {
            return false;
        }
        for (int i = 0; i < this.children.length; ++i) {
            int props = this.children[i].getSpecialProperties();
            if ((props & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    public void checkForUpdatingSubexpressions() throws XPathException {
        if (this.children == null || this.children.length < 2) {
            return;
        }
        boolean updating = false;
        boolean nonUpdating = false;
        for (int i = 0; i < this.children.length; ++i) {
            Expression act = this.children[i];
            if (!ExpressionTool.isAllowedInUpdatingContext(act)) {
                if (updating) {
                    XPathException err = new XPathException("If any subexpression is updating, then all must be updating", "XUST0001");
                    err.setLocator(this.children[i]);
                    throw err;
                }
                nonUpdating = true;
            }
            if (!act.isUpdatingExpression()) continue;
            if (nonUpdating) {
                XPathException err = new XPathException("If any subexpression is updating, then all must be updating", "XUST0001");
                err.setLocator(this.children[i]);
                throw err;
            }
            updating = true;
        }
    }

    public boolean isUpdatingExpression() {
        return this.children != null && this.children.length != 0 && this.children[0].isUpdatingExpression();
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        boolean allAtomic = true;
        boolean nested = false;
        if (this.children != null) {
            for (int c2 = 0; c2 < this.children.length; ++c2) {
                this.children[c2] = visitor.simplify(this.children[c2]);
                if (!Literal.isAtomic(this.children[c2])) {
                    allAtomic = false;
                }
                if (this.children[c2] instanceof Block) {
                    nested = true;
                    continue;
                }
                if (!Literal.isEmptySequence(this.children[c2])) continue;
                nested = true;
            }
            if (this.children.length == 1) {
                return this.getChildren()[0];
            }
            if (this.children.length == 0) {
                Literal result = Literal.makeEmptySequence();
                ExpressionTool.copyLocationInfo(this, result);
                return result;
            }
            if (nested) {
                ArrayList list = new ArrayList(this.children.length * 2);
                this.flatten(list);
                this.children = new Expression[list.size()];
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i] = (Expression)list.get(i);
                    this.adoptChildExpression(this.children[i]);
                }
            }
            if (allAtomic) {
                Item[] values = new AtomicValue[this.children.length];
                for (int c3 = 0; c3 < this.children.length; ++c3) {
                    values[c3] = (AtomicValue)((Literal)this.children[c3]).getValue();
                }
                Literal result = Literal.makeLiteral(new SequenceExtent(values));
                ExpressionTool.copyLocationInfo(this, result);
                return result;
            }
        } else {
            Literal result = Literal.makeEmptySequence();
            ExpressionTool.copyLocationInfo(this, result);
            return result;
        }
        return this;
    }

    private void flatten(List list) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] instanceof Block) {
                ((Block)this.children[i]).flatten(list);
                continue;
            }
            if (Literal.isEmptySequence(this.children[i])) continue;
            list.add(this.children[i]);
        }
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        boolean nested = false;
        if (this.children != null) {
            for (int c2 = 0; c2 < this.children.length; ++c2) {
                this.children[c2] = visitor.typeCheck(this.children[c2], contextItemType);
                this.adoptChildExpression(this.children[c2]);
                if (this.children[c2] instanceof Block) {
                    nested = true;
                    continue;
                }
                if (!Literal.isEmptySequence(this.children[c2])) continue;
                nested = true;
            }
        }
        if (nested) {
            ArrayList list = new ArrayList(this.children.length * 2);
            this.flatten(list);
            this.children = new Expression[list.size()];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = (Expression)list.get(i);
                this.adoptChildExpression(this.children[i]);
            }
        }
        if (this.children == null || this.children.length == 0) {
            return Literal.makeEmptySequence();
        }
        if (this.children.length == 1) {
            return this.children[0];
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        boolean allAtomic = true;
        if (this.children != null) {
            for (int c2 = 0; c2 < this.children.length; ++c2) {
                this.children[c2] = visitor.optimize(this.children[c2], contextItemType);
                this.adoptChildExpression(this.children[c2]);
                if (Literal.isAtomic(this.children[c2])) continue;
                allAtomic = false;
            }
            if (allAtomic) {
                Item[] items = new Item[this.children.length];
                for (int c3 = 0; c3 < this.children.length; ++c3) {
                    items[c3] = (AtomicValue)((Literal)this.children[c3]).getValue();
                }
                return new Literal(new SequenceExtent(items));
            }
        }
        return this;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (this.children != null) {
            for (int c2 = 0; c2 < this.children.length; ++c2) {
                this.children[c2] = this.doPromotion(this.children[c2], offer);
            }
        }
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (this.children != null) {
            for (int c2 = 0; c2 < this.children.length; ++c2) {
                this.children[c2].checkPermittedContents(parentType, env, false);
            }
        }
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("sequence");
        if (this.children != null) {
            for (int c2 = 0; c2 < this.children.length; ++c2) {
                this.children[c2].explain(out);
            }
        }
        out.endElement();
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        if (this.children == null) {
            return null;
        }
        TailCall tc = null;
        for (int i = 0; i < this.children.length; ++i) {
            try {
                if (this.children[i] instanceof TailCallReturner) {
                    tc = ((TailCallReturner)((Object)this.children[i])).processLeavingTail(context);
                    continue;
                }
                this.children[i].process(context);
                tc = null;
                continue;
            }
            catch (XPathException e2) {
                e2.maybeSetLocation(this.children[i]);
                e2.maybeSetContext(context);
                throw e2;
            }
        }
        return tc;
    }

    public void processLocalParams(XPathContext context) throws XPathException {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.length; ++i) {
            try {
                if (!(this.children[i] instanceof LocalParam)) {
                    return;
                }
                this.children[i].process(context);
                continue;
            }
            catch (XPathException e2) {
                e2.maybeSetLocation(this.children[i]);
                e2.maybeSetContext(context);
                throw e2;
            }
        }
    }

    public int getImplementationMethod() {
        return 6;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        if (this.children == null || this.children.length == 0) {
            return EmptyIterator.getInstance();
        }
        if (this.children.length == 1) {
            return this.children[0].iterate(context);
        }
        return new BlockIterator(this.children, context);
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        if (this.children == null || this.children.length == 0) {
            return EmptyEventIterator.getInstance();
        }
        if (this.children.length == 1) {
            return this.children[0].iterateEvents(context);
        }
        return new BlockEventIterator(this.children, context);
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].evaluatePendingUpdates(context, pul);
        }
    }
}

