/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.StringValue;

public class UnparsedEntity
extends SystemFunction
implements XSLTFunction {
    public static int URI = 0;
    public static int PUBLIC_ID = 1;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        UnparsedEntity f2 = (UnparsedEntity)super.simplify(visitor);
        f2.addContextDocumentArgument(1, this.operation == URI ? "unparsed-entity-uri_9999_" : "unparsed-entity-public-id_9999_");
        return f2;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        try {
            return super.typeCheck(visitor, contextItemType);
        }
        catch (XPathException err) {
            if ("XPDY0002".equals(err.getErrorCodeLocalPart())) {
                if (this.operation == URI) {
                    XPathException e2 = new XPathException("Cannot call the unparsed-entity-uri() function when there is no context node");
                    e2.setErrorCode("XTDE1370");
                    throw e2;
                }
                XPathException e3 = new XPathException("Cannot call the unparsed-entity-public-id() function when there is no context node");
                e3.setErrorCode("XTDE1380");
                throw e3;
            }
            throw err;
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        String[] ids;
        NodeInfo doc;
        String arg0;
        block7: {
            arg0 = this.argument[0].evaluateItem(context).getStringValue();
            doc = null;
            try {
                doc = (NodeInfo)this.argument[1].evaluateItem(context);
            }
            catch (XPathException err) {
                if ("XPDY0002".equals(err.getErrorCodeLocalPart())) {
                    if (this.operation == URI) {
                        XPathException e2 = new XPathException("Cannot call the unparsed-entity-uri() function when there is no context node");
                        e2.setErrorCode("XTDE1370");
                        throw e2;
                    }
                    XPathException e3 = new XPathException("Cannot call the unparsed-entity-public-id() function when there is no context node");
                    e3.setErrorCode("XTDE1380");
                    throw e3;
                }
                if (!"XPDY0050".equals(err.getErrorCodeLocalPart())) break block7;
                if (this.operation == URI) {
                    XPathException e4 = new XPathException("Can only call the unparsed-entity-uri() function when the context node is in a tree rooted at a document node");
                    e4.setErrorCode("XTDE1370");
                    throw e4;
                }
                XPathException e5 = new XPathException("Can only call the unparsed-entity-public-id() function when the context node is in a tree rooted at a document node");
                e5.setErrorCode("XTDE1380");
                throw e5;
            }
        }
        if (doc.getNodeKind() != 9) {
            String code = this.operation == URI ? "XTDE1370" : "XTDE1380";
            this.dynamicError("In function " + this.getDisplayName() + ", the context node must be in a tree whose root is a document node", code, context);
        }
        if ((ids = ((DocumentInfo)doc).getUnparsedEntity(arg0)) == null) {
            return StringValue.EMPTY_STRING;
        }
        return new StringValue(ids[this.operation]);
    }
}

