/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class StringJoin
extends SystemFunction {
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp instanceof StringJoin) {
            return ((StringJoin)exp).simplifySingleton();
        }
        return exp;
    }

    private Expression simplifySingleton() {
        int card = this.argument[0].getCardinality();
        if (!Cardinality.allowsMany(card)) {
            if (Cardinality.allowsZero(card)) {
                return SystemFunction.makeSystemFunction("string", new Expression[]{this.argument[0]});
            }
            return this.argument[0];
        }
        return this;
    }

    public Item evaluateItem(XPathContext c2) throws XPathException {
        SequenceIterator iter = this.argument[0].iterate(c2);
        Item it = iter.next();
        if (it == null) {
            return StringValue.EMPTY_STRING;
        }
        CharSequence first = it.getStringValueCS();
        it = iter.next();
        if (it == null) {
            return StringValue.makeStringValue(first);
        }
        FastStringBuffer sb = new FastStringBuffer(1024);
        sb.append(first);
        CharSequence sep = this.argument[1].evaluateItem(c2).getStringValueCS();
        sb.append(sep);
        sb.append(it.getStringValueCS());
        while ((it = iter.next()) != null) {
            sb.append(sep);
            sb.append(it.getStringValueCS());
        }
        return StringValue.makeStringValue(sb.condense());
    }
}

