/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public class NormalizeSpace
extends SystemFunction {
    public int getIntrinsicDependencies() {
        int d2 = super.getIntrinsicDependencies();
        if (this.argument.length == 0) {
            d2 |= 2;
        }
        return d2;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.argument.length == 0 && contextItemType == null) {
            XPathException err = new XPathException("The context item for normalize-space() is undefined");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        return super.typeCheck(visitor, contextItemType);
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.argument.length == 0) {
            return this;
        }
        return Literal.makeLiteral((Value)((Object)this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext())));
    }

    public Item evaluateItem(XPathContext c2) throws XPathException {
        if (this.argument.length == 0) {
            Item item = c2.getContextItem();
            if (item == null) {
                this.dynamicError("Context item for normalize-space() is undefined", "FONC0001", c2);
                return null;
            }
            return StringValue.makeStringValue(Whitespace.collapseWhitespace(item.getStringValueCS()));
        }
        AtomicValue sv = (AtomicValue)this.argument[0].evaluateItem(c2);
        if (sv == null) {
            return StringValue.EMPTY_STRING;
        }
        return StringValue.makeStringValue(Whitespace.collapseWhitespace(sv.getStringValueCS()));
    }

    public boolean effectiveBooleanValue(XPathContext c2) throws XPathException {
        CharSequence cs;
        if (this.argument.length == 0) {
            Item item = c2.getContextItem();
            if (item == null) {
                this.dynamicError("Context item for normalize-space() is undefined", "FONC0001", c2);
                return false;
            }
            cs = item.getStringValueCS();
        } else {
            AtomicValue sv = (AtomicValue)this.argument[0].evaluateItem(c2);
            if (sv == null) {
                return false;
            }
            cs = sv.getStringValueCS();
        }
        return !Whitespace.isWhite(cs);
    }
}

