/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;

public class Lang
extends SystemFunction {
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.argument.length == 1) {
            if (contextItemType == null) {
                XPathException err = new XPathException("The context item for lang() is undefined");
                err.setErrorCode("XPDY0002");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
            if (contextItemType instanceof AtomicType) {
                XPathException err = new XPathException("The context item for lang() is not a node");
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
        }
        return super.typeCheck(visitor, contextItemType);
    }

    public Item evaluateItem(XPathContext c2) throws XPathException {
        NodeInfo target;
        if (this.argument.length > 1) {
            target = (NodeInfo)this.argument[1].evaluateItem(c2);
        } else {
            Item current = c2.getContextItem();
            if (current == null) {
                XPathException err = new XPathException("The context item is undefined");
                err.setErrorCode("XPDY0002");
                err.setXPathContext(c2);
                throw err;
            }
            if (!(current instanceof NodeInfo)) {
                XPathException err = new XPathException("The context item is not a node");
                err.setErrorCode("XPTY0004");
                err.setXPathContext(c2);
                throw err;
            }
            target = (NodeInfo)current;
        }
        Item arg0Val = this.argument[0].evaluateItem(c2);
        String testLang = arg0Val == null ? "" : arg0Val.getStringValue();
        boolean b2 = Lang.isLang(testLang, target);
        return BooleanValue.get(b2);
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public static boolean isLang(String arglang, NodeInfo target) {
        String doclang = null;
        NodeInfo node = target;
        while (node != null && (doclang = node.getAttributeValue(387)) == null) {
            if ((node = node.getParent()) != null) continue;
            return false;
        }
        if (doclang == null) {
            return false;
        }
        if (arglang.equalsIgnoreCase(doclang)) {
            return true;
        }
        int hyphen = doclang.indexOf("-");
        if (hyphen < 0) {
            return false;
        }
        return arglang.equalsIgnoreCase(doclang = doclang.substring(0, hyphen));
    }
}

