/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.charcode.UTF16;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.exslt.Math;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.Evaluate;
import net.sf.saxon.number.NamedTimeZone;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.ProcInstParser;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.sort.SortKeyEvaluator;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Value;

public class Extensions {
    private Extensions() {
    }

    public static void pauseTracing(XPathContext c2) {
        c2.getController().pauseTracing(true);
    }

    public static void resumeTracing(XPathContext c2) {
        c2.getController().pauseTracing(false);
    }

    public static String systemId(XPathContext c2) throws XPathException {
        Item item = c2.getContextItem();
        if (item == null) {
            XPathException e2 = new XPathException("The context item for saxon:systemId() is not set");
            e2.setXPathContext(c2);
            throw e2;
        }
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getSystemId();
        }
        return "";
    }

    public static String generateId(NodeInfo node) {
        FastStringBuffer buffer = new FastStringBuffer(16);
        node.generateId(buffer);
        return buffer.toString();
    }

    public static int lineNumber(XPathContext c2) {
        Item item = c2.getContextItem();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getLineNumber();
        }
        return -1;
    }

    public static int lineNumber(NodeInfo node) {
        if (node == null) {
            return -1;
        }
        return node.getLineNumber();
    }

    public static int columnNumber(XPathContext c2) {
        Item item = c2.getCurrentIterator().current();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getColumnNumber();
        }
        return -1;
    }

    public static int columnNumber(NodeInfo node) {
        if (node == null) {
            return -1;
        }
        return node.getColumnNumber();
    }

    public static DocumentInfo discardDocument(XPathContext context, DocumentInfo doc) {
        if (doc == null) {
            return null;
        }
        Controller c2 = context.getController();
        String uri = c2.getDocumentPool().getDocumentURI(doc);
        if (uri != null) {
            c2.removeUnavailableOutputDestination(uri);
        }
        return c2.getDocumentPool().discard(doc);
    }

    public static boolean hasSameNodes(SequenceIterator p1, SequenceIterator p2) throws XPathException {
        NodeInfo n2;
        NodeInfo n1;
        SequenceIterator e1 = p1;
        SequenceIterator e2 = p2;
        if (e1 == null) {
            e1 = EmptyIterator.getInstance();
        }
        if (e2 == null) {
            e2 = EmptyIterator.getInstance();
        }
        do {
            n1 = (NodeInfo)e1.next();
            n2 = (NodeInfo)e2.next();
            if (n1 != null && n2 != null) continue;
            return n1 == n2;
        } while (n1.isSameNodeInfo(n2));
        return false;
    }

    public static SequenceIterator sort(XPathContext context, SequenceIterator input) {
        SortKeyEvaluator sortkey = new SortKeyEvaluator(){

            public Item evaluateSortKey(int n, XPathContext context) throws XPathException {
                Item c2 = context.getContextItem();
                if (c2 instanceof NodeInfo) {
                    Value v = ((NodeInfo)c2).atomize();
                    if (v.getLength() == 0) {
                        c2 = null;
                    } else if (v.getLength() == 1) {
                        c2 = v.itemAt(0);
                    } else {
                        throw new XPathException("error in saxon:sort() - a node has a typed value of length > 1");
                    }
                }
                return c2;
            }
        };
        AtomicComparer[] comparers = new AtomicComparer[]{new GenericAtomicComparer(CodepointCollator.getInstance(), context)};
        return new SortedIterator(context, input, sortkey, comparers);
    }

    public static SequenceIterator sort(XPathContext context, SequenceIterator input, final Evaluate.PreparedExpression sortKeyExpression) {
        SortKeyEvaluator sortkey = new SortKeyEvaluator(){

            public Item evaluateSortKey(int n, XPathContext context) throws XPathException {
                Item c2 = sortKeyExpression.expression.evaluateItem(context);
                if (c2 instanceof NodeInfo) {
                    Value v = ((NodeInfo)c2).atomize();
                    if (v.getLength() == 0) {
                        c2 = null;
                    } else if (v.getLength() == 1) {
                        c2 = v.itemAt(0);
                    } else {
                        throw new XPathException("error in saxon:sort() - a node has a typed value of length > 1");
                    }
                }
                return c2;
            }
        };
        AtomicComparer[] comparers = new AtomicComparer[]{new GenericAtomicComparer(CodepointCollator.getInstance(), context)};
        return new SortedIterator(context, input, sortkey, comparers);
    }

    public static Value highest(SequenceIterator nsv) throws XPathException {
        return Math.highest(nsv);
    }

    public static SequenceIterator highest(XPathContext context, SequenceIterator nsv, Evaluate.PreparedExpression pexpression) throws XPathException {
        Item next;
        if (nsv == null) {
            return EmptyIterator.getInstance();
        }
        if (pexpression == null) {
            return EmptyIterator.getInstance();
        }
        double max = Double.NEGATIVE_INFINITY;
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOriginatingConstructType(2052);
        Item highest = null;
        c2.setCurrentIterator(nsv);
        while ((next = nsv.next()) != null) {
            Item val = pexpression.expression.evaluateItem(c2);
            if (val instanceof NumericValue) {
                DoubleValue v = (DoubleValue)((NumericValue)val).convert(BuiltInAtomicType.DOUBLE, true, context).asAtomic();
                if (!(v.getDoubleValue() > max)) continue;
                max = v.getDoubleValue();
                highest = nsv.current();
                continue;
            }
            XPathException e2 = new XPathException("expression in saxon:highest() must return numeric values");
            e2.setXPathContext(context);
            throw e2;
        }
        return SingletonIterator.makeIterator(highest);
    }

    public static Value lowest(SequenceIterator nsv) throws XPathException {
        return Math.lowest(nsv);
    }

    public static SequenceIterator lowest(XPathContext context, SequenceIterator nsv, Evaluate.PreparedExpression pexpression) throws XPathException {
        Item next;
        if (nsv == null) {
            return EmptyIterator.getInstance();
        }
        if (pexpression == null) {
            return EmptyIterator.getInstance();
        }
        double min = Double.POSITIVE_INFINITY;
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOriginatingConstructType(2052);
        Item lowest = null;
        c2.setCurrentIterator(nsv);
        while ((next = nsv.next()) != null) {
            Item val = pexpression.expression.evaluateItem(c2);
            if (val instanceof NumericValue) {
                DoubleValue v = (DoubleValue)((NumericValue)val).convert(BuiltInAtomicType.DOUBLE, true, context).asAtomic();
                if (!(v.getDoubleValue() < min)) continue;
                min = v.getDoubleValue();
                lowest = nsv.current();
                continue;
            }
            XPathException e2 = new XPathException("expression in saxon:lowest() must return numeric values");
            e2.setXPathContext(context);
            throw e2;
        }
        return SingletonIterator.makeIterator(lowest);
    }

    public static SequenceIterator leading(XPathContext context, SequenceIterator in, Evaluate.PreparedExpression pexp) {
        if (in == null) {
            return EmptyIterator.getInstance();
        }
        if (pexp == null) {
            return EmptyIterator.getInstance();
        }
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOriginatingConstructType(2052);
        return new FilterIterator.Leading(in, pexp.expression, c2);
    }

    public static SequenceIterator after(XPathContext context, SequenceIterator ns1, SequenceIterator ns2) throws XPathException {
        NodeInfo first;
        block4: {
            first = null;
            GlobalOrderComparer comparer = GlobalOrderComparer.getInstance();
            while (true) {
                Item item;
                if ((item = ns2.next()) == null) {
                    if (first == null) {
                        return ns1;
                    }
                    break block4;
                }
                if (!(item instanceof NodeInfo)) break;
                NodeInfo node = (NodeInfo)item;
                if (first == null) {
                    first = node;
                    continue;
                }
                if (comparer.compare(node, first) >= 0) continue;
                first = node;
            }
            XPathException e2 = new XPathException("Operand of after() contains an item that is not a node");
            e2.setXPathContext(context);
            throw e2;
        }
        IdentityComparison filter = new IdentityComparison(new ContextItemExpression(), 38, new Literal(new SingletonNode(first)));
        return new FilterIterator(ns1, filter, context);
    }

    public static String path(NodeInfo node) throws XPathException {
        return Navigator.getPath(node);
    }

    public static String path(XPathContext c2) throws XPathException {
        Item item = c2.getContextItem();
        if (item == null) {
            XPathException e2 = new XPathException("The context item for saxon:path() is not set");
            e2.setXPathContext(c2);
            throw e2;
        }
        if (item instanceof NodeInfo) {
            return Navigator.getPath((NodeInfo)item);
        }
        return "";
    }

    public static QNameValue typeAnnotation(XPathContext context, Item item) {
        if (item == null) {
            return null;
        }
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            int code = node.getTypeAnnotation();
            if ((code & 0x40000000) != 0) {
                code = 631;
            }
            if (code == -1) {
                int nodeKind = node.getNodeKind();
                if (nodeKind == 1 || nodeKind == 9) {
                    return new QNameValue("xs", "http://www.w3.org/2001/XMLSchema", "untyped");
                }
                return new QNameValue("xs", "http://www.w3.org/2001/XMLSchema", "untypedAtomic");
            }
            return new QNameValue(context.getNamePool(), code);
        }
        AtomicType label = ((AtomicValue)item).getTypeLabel();
        return new QNameValue(context.getNamePool(), label.getNameCode());
    }

    public static XPathContext getContext(XPathContext c2) {
        return c2;
    }

    public static Controller getController(XPathContext c2) {
        return c2.getController();
    }

    public static Configuration getConfiguration(XPathContext c2) {
        return c2.getConfiguration();
    }

    public static String printStack(XPathContext c2) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        StandardErrorListener.printStackTrace(new PrintStream(baos), c2);
        return baos.toString();
    }

    public static String getPseudoAttribute(XPathContext c2, String name) throws XPathException {
        if (name == null) {
            return null;
        }
        Item pi = c2.getContextItem();
        if (pi == null) {
            XPathException e2 = new XPathException("The context item for saxon:getPseudoAttribute() is not set");
            e2.setXPathContext(c2);
            throw e2;
        }
        String val = ProcInstParser.getPseudoAttribute(pi.getStringValue(), name);
        if (val == null) {
            return "";
        }
        return val;
    }

    public static BigDecimal decimalDivide(BigDecimal arg1, BigDecimal arg2, int scale) {
        if (arg1 == null || arg2 == null) {
            return null;
        }
        return arg1.divide(arg2, scale, 1);
    }

    public static List stringToUtf8(String in) {
        if (in == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(in.length() * 2);
        byte[] octets = new byte[4];
        for (int i = 0; i < in.length(); ++i) {
            int used = UnicodeCharacterSet.getUTF8Encoding(in.charAt(i), i + 1 < in.length() ? in.charAt(i + 1) : (char)'\u0000', octets);
            for (int j = 0; j < used; ++j) {
                list.add(new Integer(0xFF & octets[j]));
            }
        }
        return list;
    }

    public static Base64BinaryValue octetsToBase64Binary(byte[] in) {
        if (in == null) {
            return null;
        }
        return new Base64BinaryValue(in);
    }

    public static HexBinaryValue octetsToHexBinary(byte[] in) {
        if (in == null) {
            return null;
        }
        return new HexBinaryValue(in);
    }

    public static byte[] base64BinaryToOctets(Base64BinaryValue in) {
        if (in == null) {
            return null;
        }
        return in.getBinaryValue();
    }

    public static byte[] hexBinaryToOctets(HexBinaryValue in) {
        if (in == null) {
            return null;
        }
        return in.getBinaryValue();
    }

    public static String base64BinaryToString(XPathContext context, Base64BinaryValue in, String encoding) throws Exception {
        if (in == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        byte[] bytes = in.getBinaryValue();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, encoding);
        char[] array = new char[bytes.length];
        int used = reader.read(array, 0, array.length);
        Extensions.checkBytes(array, 0, used, context.getConfiguration().getNameChecker());
        return new String(array, 0, used);
    }

    public static Base64BinaryValue stringToBase64Binary(String in, String encoding) throws IOException {
        if (in == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(in.length());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, encoding);
        writer.write(in);
        writer.close();
        byte[] bytes = stream.toByteArray();
        return Extensions.octetsToBase64Binary(bytes);
    }

    public static String hexBinaryToString(XPathContext context, HexBinaryValue in, String encoding) throws Exception {
        if (in == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        byte[] bytes = in.getBinaryValue();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, encoding);
        char[] array = new char[bytes.length];
        int used = reader.read(array, 0, array.length);
        Extensions.checkBytes(array, 0, used, context.getConfiguration().getNameChecker());
        return new String(array, 0, used);
    }

    private static void checkBytes(char[] array, int start, int end, NameChecker checker) throws XPathException {
        for (int c2 = start; c2 < end; ++c2) {
            int ch32 = array[c2];
            if (UTF16.isHighSurrogate(ch32)) {
                char low = array[c2++];
                ch32 = UTF16.combinePair((char)ch32, low);
            }
            if (checker.isValidChar(ch32)) continue;
            XPathException err = new XPathException("The byte sequence contains a character not allowed by XML (hex " + Integer.toHexString(ch32) + ')');
            err.setErrorCode("XTDE1180");
            throw err;
        }
    }

    public static HexBinaryValue stringToHexBinary(String in, String encoding) throws Exception {
        if (in == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(in.length());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, encoding);
        writer.write(in);
        writer.close();
        byte[] bytes = stream.toByteArray();
        return Extensions.octetsToHexBinary(bytes);
    }

    public static boolean validCharacter(XPathContext c2, int in) {
        return c2.getConfiguration().getNameChecker().isValidChar(in);
    }

    public static NodeInfo namespaceNode(XPathContext context, String prefix, String uri) throws XPathException {
        if (prefix == null) {
            prefix = "";
        } else if (prefix.length() != 0 && !context.getConfiguration().getNameChecker().isValidNCName(prefix)) {
            throw new XPathException("Namespace prefix " + Err.wrap(prefix) + " is not a valid NCName");
        }
        if (uri == null || uri.length() == 0) {
            throw new XPathException("URI of namespace node must not be empty");
        }
        NamePool namePool = context.getNamePool();
        Orphan node = new Orphan(context.getConfiguration());
        node.setNodeKind((short)13);
        node.setNameCode(namePool.allocate("", "", prefix));
        node.setStringValue(uri);
        return node;
    }

    public static String[] unparsedEntities(DocumentInfo doc) throws XPathException {
        Iterator names = doc.getUnparsedEntityNames();
        int count = 0;
        while (names.hasNext()) {
            names.next();
            ++count;
        }
        String[] ss = new String[count];
        names = doc.getUnparsedEntityNames();
        count = 0;
        while (names.hasNext()) {
            ss[count++] = (String)names.next();
        }
        return ss;
    }

    public static boolean deepEqual(XPathContext context, SequenceIterator arg1, SequenceIterator arg2, String collation, String flags) throws XPathException {
        if (flags.indexOf(33) >= 0) {
            Properties indent = new Properties();
            indent.setProperty("indent", "yes");
            System.err.println("DeepEqual: first argument:");
            QueryResult.serialize(QueryResult.wrap(arg1.getAnother(), context.getConfiguration()), new StreamResult(System.err), indent);
            System.err.println("DeepEqual: second argument:");
            QueryResult.serialize(QueryResult.wrap(arg2.getAnother(), context.getConfiguration()), new StreamResult(System.err), indent);
        }
        GenericAtomicComparer comparer = collation == null ? new GenericAtomicComparer(context.getDefaultCollation(), context) : new GenericAtomicComparer(context.getCollation(collation), context);
        int flag = 0;
        if (flags.indexOf("N") >= 0) {
            flag |= 1;
        }
        if (flags.indexOf("J") >= 0) {
            flag |= 0x100;
        }
        if (flags.indexOf("C") >= 0) {
            flag |= 4;
        }
        if (flags.indexOf("P") >= 0) {
            flag |= 8;
        }
        if (flags.indexOf("F") >= 0) {
            flag |= 2;
        }
        if (flags.indexOf("S") >= 0) {
            flag |= 0x20;
        }
        if (flags.indexOf("A") >= 0) {
            flag |= 0x40;
        }
        if (flags.indexOf("w") >= 0) {
            flag |= 0x10;
        }
        if (flags.indexOf("?") >= 0) {
            flag |= 0x80;
        }
        return DeepEqual.deepEquals(arg1, arg2, comparer, context.getConfiguration(), flag);
    }

    public static DateTimeValue lastModified(XPathContext c2) throws XPathException {
        Item item = c2.getContextItem();
        if (item == null) {
            XPathException e2 = new XPathException("The context item for lastModified() is not set");
            e2.setXPathContext(c2);
            throw e2;
        }
        if (item instanceof NodeInfo) {
            return Extensions.lastModified(c2, (NodeInfo)item);
        }
        return null;
    }

    public static DateTimeValue lastModified(XPathContext context, NodeInfo node) throws XPathException {
        return Extensions.fileLastModified(context, node.getSystemId());
    }

    public static DateTimeValue fileLastModified(XPathContext context, String fileURI) throws XPathException {
        long lastMod;
        URL absoluteURL;
        URI absoluteURI;
        boolean debug = context.getConfiguration().isTraceExternalFunctions();
        try {
            absoluteURI = new URI(fileURI);
        }
        catch (URISyntaxException e2) {
            if (debug) {
                throw new XPathException(e2);
            }
            return null;
        }
        if (!absoluteURI.isAbsolute()) {
            if (debug) {
                throw new XPathException("Supplied URI " + fileURI + " is not a valid absolute URI");
            }
            return null;
        }
        try {
            EscapeURI.checkPercentEncoding(absoluteURI.toString());
        }
        catch (XPathException e3) {
            if (debug) {
                throw e3;
            }
            return null;
        }
        try {
            absoluteURL = absoluteURI.toURL();
        }
        catch (MalformedURLException err) {
            if (debug) {
                throw new XPathException(err);
            }
            return null;
        }
        try {
            URLConnection connection = absoluteURL.openConnection();
            connection.setRequestProperty("Accept-Encoding", "gzip");
            connection.connect();
            lastMod = connection.getLastModified();
        }
        catch (IOException e4) {
            if (debug) {
                throw new XPathException(e4);
            }
            return null;
        }
        if (lastMod == 0L) {
            return null;
        }
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(lastMod);
        return new DateTimeValue(c2, true);
    }

    public static BooleanValue inSummerTime(XPathContext context, DateTimeValue date, String region) {
        Boolean b2;
        if (!date.hasTimezone()) {
            try {
                date = (DateTimeValue)date.adjustTimezone(context.getImplicitTimezone());
            }
            catch (NoDynamicContextException err) {
                date = (DateTimeValue)date.adjustTimezone(0);
            }
        }
        return (b2 = NamedTimeZone.inSummerTime(date, region)) == null ? null : BooleanValue.get(b2);
    }

    public static Templates compileStylesheet(XPathContext context, DocumentInfo doc) throws XPathException {
        if (doc == null) {
            return null;
        }
        try {
            TransformerFactoryImpl factory = new TransformerFactoryImpl(context.getConfiguration());
            return factory.newTemplates(doc);
        }
        catch (TransformerConfigurationException e2) {
            throw XPathException.makeXPathException(e2);
        }
    }

    public static DocumentInfo transform(XPathContext context, Templates templates, NodeInfo source) throws XPathException {
        if (templates == null) {
            return null;
        }
        if (source == null) {
            return null;
        }
        try {
            Transformer transformer = templates.newTransformer();
            TinyBuilder builder = new TinyBuilder();
            builder.setPipelineConfiguration(context.getController().makePipelineConfiguration());
            transformer.transform(source, builder);
            return (DocumentInfo)builder.getCurrentRoot();
        }
        catch (TransformerException e2) {
            throw XPathException.makeXPathException(e2);
        }
    }

    public static DocumentInfo transform(XPathContext context, Templates templates, NodeInfo source, SequenceIterator params) throws XPathException {
        if (templates == null) {
            return null;
        }
        if (source == null) {
            return null;
        }
        try {
            Item param;
            Transformer transformer = templates.newTransformer();
            TinyBuilder builder = new TinyBuilder();
            builder.setPipelineConfiguration(context.getController().makePipelineConfiguration());
            while ((param = params.next()) != null) {
                if (param instanceof NodeInfo) {
                    switch (((NodeInfo)param).getNodeKind()) {
                        case 1: 
                        case 2: {
                            Extensions.setTransformerParameter(param, transformer, source);
                            break;
                        }
                        case 9: {
                            NodeInfo kid;
                            AxisIterator kids = ((NodeInfo)param).iterateAxis((byte)3, NodeKindTest.ELEMENT);
                            while ((kid = (NodeInfo)kids.next()) != null) {
                                Extensions.setTransformerParameter(kid, transformer, source);
                            }
                            break;
                        }
                        default: {
                            throw new XPathException("Parameters passed to saxon:transform() must be element, attribute, or document nodes");
                        }
                    }
                    continue;
                }
                throw new XPathException("Parameters passed to saxon:transform() must be nodes");
            }
            transformer.transform(source, builder);
            return (DocumentInfo)builder.getCurrentRoot();
        }
        catch (TransformerException e2) {
            throw XPathException.makeXPathException(e2);
        }
    }

    private static void setTransformerParameter(Item param, Transformer transformer, NodeInfo source) throws XPathException {
        int fp = ((NodeInfo)param).getFingerprint();
        if (fp != -1) {
            Value val = ((NodeInfo)param).atomize();
            ((Controller)transformer).setParameter(new StructuredQName(source.getNamePool(), fp), val);
        }
    }

    public static XQueryExpression compileQuery(XPathContext context, String query) throws XPathException {
        if (query == null) {
            return null;
        }
        StaticQueryContext sqc = new StaticQueryContext(context.getConfiguration());
        return sqc.compileQuery(query);
    }

    public static SequenceIterator query(XPathContext context, XQueryExpression query) throws XPathException {
        if (query == null) {
            return null;
        }
        DynamicQueryContext dqc = new DynamicQueryContext(context.getConfiguration());
        Item c2 = context.getContextItem();
        if (c2 != null) {
            dqc.setContextItem(c2);
        }
        return query.iterator(dqc);
    }

    public static SequenceIterator query(XPathContext context, XQueryExpression query, Item source) throws XPathException {
        if (query == null) {
            return null;
        }
        DynamicQueryContext dqc = new DynamicQueryContext(context.getConfiguration());
        if (source != null) {
            dqc.setContextItem(source);
        }
        return query.iterator(dqc);
    }

    public static SequenceIterator query(XPathContext context, XQueryExpression query, Item source, SequenceIterator params) throws XPathException {
        Item param;
        if (query == null) {
            return null;
        }
        DynamicQueryContext dqc = new DynamicQueryContext(context.getConfiguration());
        if (source != null) {
            dqc.setContextItem(source);
        }
        NamePool pool = context.getConfiguration().getNamePool();
        while ((param = params.next()) != null) {
            if (param instanceof NodeInfo) {
                switch (((NodeInfo)param).getNodeKind()) {
                    case 1: 
                    case 2: {
                        Value val = ((NodeInfo)param).atomize();
                        dqc.setParameter(pool.getClarkName(((NodeInfo)param).getNameCode()), val);
                        break;
                    }
                    case 9: {
                        NodeInfo kid;
                        AxisIterator kids = ((NodeInfo)param).iterateAxis((byte)3, NodeKindTest.ELEMENT);
                        while ((kid = (NodeInfo)kids.next()) != null) {
                            Value val2 = ((NodeInfo)param).atomize();
                            dqc.setParameter(pool.getClarkName(kid.getNameCode()), val2);
                        }
                        break;
                    }
                    default: {
                        throw new XPathException("Parameters passed to saxon:query() must be element, attribute, or document nodes");
                    }
                }
                continue;
            }
            throw new XPathException("Parameters passed to saxon:query() must be nodes");
        }
        return query.iterator(dqc);
    }
}

