/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;

public class DocAvailable
extends SystemFunction {
    private String expressionBaseURI = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(context);
        if (hrefVal == null) {
            return BooleanValue.FALSE;
        }
        String href = hrefVal.getStringValue();
        Controller controller = context.getController();
        ErrorListener old = controller.getErrorListener();
        controller.setErrorListener(new ErrorListener(){

            public void warning(TransformerException exception) {
            }

            public void error(TransformerException exception) {
            }

            public void fatalError(TransformerException exception) {
            }
        });
        try {
            boolean b2 = this.docAvailable(href, context);
            controller.setErrorListener(old);
            return BooleanValue.get(b2);
        }
        catch (URISyntaxException err) {
            controller.setErrorListener(old);
            XPathException xe = new XPathException(err);
            xe.setErrorCode("FODC0005");
            xe.setXPathContext(context);
            xe.setLocator(this);
            throw xe;
        }
    }

    private boolean docAvailable(String href, XPathContext context) throws URISyntaxException {
        try {
            NodeInfo item = Document.makeDoc(href, this.expressionBaseURI, context, this);
            return item != null;
        }
        catch (Exception err) {
            new URI(href);
            return false;
        }
    }
}

