/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.trans.XPathException;

public class CurrentGroup
extends SystemFunction
implements XSLTFunction {
    public static final int CURRENT_GROUP = 0;
    public static final int CURRENT_GROUPING_KEY = 1;

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Item evaluateItem(XPathContext c2) throws XPathException {
        if (this.operation == 1) {
            GroupIterator gi = c2.getCurrentGroupIterator();
            if (gi == null) {
                return null;
            }
            return gi.getCurrentGroupingKey();
        }
        return super.evaluateItem(c2);
    }

    public SequenceIterator iterate(XPathContext c2) throws XPathException {
        if (this.operation == 0) {
            GroupIterator gi = c2.getCurrentGroupIterator();
            if (gi == null) {
                return EmptyIterator.getInstance();
            }
            return gi.iterateCurrentGroup();
        }
        return super.iterate(c2);
    }

    public int getIntrinsicDependencies() {
        return 32;
    }
}

