/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class BooleanFn
extends SystemFunction
implements Negatable {
    public static final int BOOLEAN = 0;
    public static final int NOT = 1;
    public static final int TRUE = 2;
    public static final int FALSE = 3;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        switch (this.operation) {
            case 0: 
            case 1: {
                return super.simplify(visitor);
            }
            case 2: {
                return Literal.makeLiteral(BooleanValue.TRUE);
            }
            case 3: {
                return Literal.makeLiteral(BooleanValue.FALSE);
            }
        }
        throw new UnsupportedOperationException("Unknown boolean operation");
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        if (this.operation == 0 || this.operation == 1) {
            XPathException err = TypeChecker.ebvError(this.argument[0], visitor.getConfiguration().getTypeHierarchy());
            if (err != null) {
                err.setLocator(this);
                throw err;
            }
            Optimizer opt = visitor.getConfiguration().getOptimizer();
            this.argument[0] = ExpressionTool.unsortedIfHomogeneous(opt, this.argument[0]);
        }
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e2 = super.optimize(visitor, contextItemType);
        if (e2 == this) {
            if (this.operation == 0) {
                Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.argument[0], visitor, contextItemType);
                return ebv == null ? this : ebv.optimize(visitor, contextItemType);
            }
            if (this.operation == 1) {
                Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.argument[0], visitor, contextItemType);
                if (ebv != null) {
                    this.argument[0] = ebv;
                }
                if (this.argument[0] instanceof Negatable && ((Negatable)((Object)this.argument[0])).isNegatable(visitor)) {
                    return ((Negatable)((Object)this.argument[0])).negate();
                }
                return this;
            }
        }
        return e2;
    }

    public boolean isNegatable(ExpressionVisitor visitor) {
        return true;
    }

    public Expression negate() {
        switch (this.operation) {
            case 0: {
                return SystemFunction.makeSystemFunction("not", this.getArguments());
            }
            case 1: {
                return SystemFunction.makeSystemFunction("boolean", this.getArguments());
            }
            case 2: {
                return new Literal(BooleanValue.FALSE);
            }
        }
        return new Literal(BooleanValue.TRUE);
    }

    public static Expression rewriteEffectiveBooleanValue(Expression exp, ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        exp = ExpressionTool.unsortedIfHomogeneous(config.getOptimizer(), exp);
        if (exp instanceof ValueComparison) {
            ValueComparison vc = (ValueComparison)exp;
            if (vc.getResultWhenEmpty() == null) {
                vc.setResultWhenEmpty(BooleanValue.FALSE);
            }
            return exp;
        }
        if (th.isSubType(exp.getItemType(th), BuiltInAtomicType.BOOLEAN) && exp.getCardinality() == 16384) {
            return exp;
        }
        if (exp.getItemType(th) instanceof NodeTest) {
            FunctionCall exists = SystemFunction.makeSystemFunction("exists", new Expression[]{exp});
            exists.setLocationId(exp.getLocationId());
            return exists.optimize(visitor, contextItemType);
        }
        return null;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext c2) throws XPathException {
        try {
            switch (this.operation) {
                case 0: {
                    return this.argument[0].effectiveBooleanValue(c2);
                }
                case 1: {
                    return !this.argument[0].effectiveBooleanValue(c2);
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
            }
            throw new UnsupportedOperationException("Unknown boolean operation");
        }
        catch (XPathException e2) {
            e2.maybeSetLocation(this);
            e2.maybeSetContext(c2);
            throw e2;
        }
    }
}

