/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

public class PathMap {
    private List pathMapRoots = new ArrayList();
    private HashMap pathsForVariables = new HashMap();

    public PathMap(Expression exp) {
        PathMapNodeSet finalNodes = exp.addToPathMap(this, null);
        if (finalNodes != null) {
            Iterator iter = finalNodes.iterator();
            while (iter.hasNext()) {
                PathMapNode node = (PathMapNode)iter.next();
                node.setReturnable(true);
            }
        }
    }

    public PathMapRoot makeNewRoot(Expression exp) {
        for (int i = 0; i < this.pathMapRoots.size(); ++i) {
            PathMapRoot r = (PathMapRoot)this.pathMapRoots.get(i);
            if (!exp.equals(r.getRootExpression())) continue;
            return r;
        }
        PathMapRoot root = new PathMapRoot(exp);
        this.pathMapRoots.add(root);
        return root;
    }

    public PathMapRoot[] getPathMapRoots() {
        return this.pathMapRoots.toArray(new PathMapRoot[this.pathMapRoots.size()]);
    }

    public void registerPathForVariable(Binding binding, PathMapNodeSet nodeset) {
        this.pathsForVariables.put(binding, nodeset);
    }

    public PathMapNodeSet getPathForVariable(Binding binding) {
        return (PathMapNodeSet)this.pathsForVariables.get(binding);
    }

    public PathMapRoot getContextRoot() {
        PathMapRoot[] roots = this.getPathMapRoots();
        PathMapRoot contextRoot = null;
        for (int r = 0; r < roots.length; ++r) {
            PathMapRoot newRoot = this.reduceToDownwardsAxes(roots[r]);
            if (!(newRoot.getRootExpression() instanceof RootExpression)) continue;
            if (contextRoot != null) {
                throw new IllegalStateException("More than one context document root found in path map");
            }
            contextRoot = newRoot;
        }
        return contextRoot;
    }

    public PathMapRoot getRootForDocument(String requiredUri) {
        PathMapRoot[] roots = this.getPathMapRoots();
        PathMapRoot requiredRoot = null;
        for (int r = 0; r < roots.length; ++r) {
            PathMapRoot newRoot = this.reduceToDownwardsAxes(roots[r]);
            Expression exp = newRoot.getRootExpression();
            String baseUri = null;
            if (exp instanceof Doc) {
                baseUri = ((Doc)exp).getStaticBaseURI();
            } else if (exp instanceof Document) {
                baseUri = ((Document)exp).getStaticBaseURI();
            }
            Expression arg = ((SystemFunction)exp).getArguments()[0];
            String suppliedUri = null;
            if (arg instanceof Literal) {
                try {
                    String argValue = ((Literal)arg).getValue().getStringValue();
                    suppliedUri = baseUri == null ? (new URI(argValue).isAbsolute() ? argValue : null) : Configuration.getPlatform().makeAbsolute(argValue, baseUri).toString();
                }
                catch (URISyntaxException err) {
                    suppliedUri = null;
                }
                catch (XPathException err) {
                    suppliedUri = null;
                }
            }
            if (!requiredUri.equals(suppliedUri)) continue;
            if (requiredRoot != null) {
                throw new IllegalStateException("More than one document root found in path map for " + requiredUri);
            }
            requiredRoot = newRoot;
        }
        return requiredRoot;
    }

    public PathMapRoot reduceToDownwardsAxes(PathMapRoot root) {
        if (root.isDownwardsOnly) {
            return root;
        }
        PathMapRoot newRoot = root;
        if (root.getRootExpression() instanceof ContextItemExpression) {
            int i;
            RootExpression slash = new RootExpression();
            slash.setContainer(root.getRootExpression().getContainer());
            newRoot = this.makeNewRoot(slash);
            block3: for (i = root.arcs.size() - 1; i >= 0; --i) {
                PathMapArc arc = (PathMapArc)root.arcs.get(i);
                byte axis = arc.getStep().getAxis();
                switch (axis) {
                    case 2: 
                    case 8: {
                        AxisExpression newStep = new AxisExpression(4, NodeKindTest.ELEMENT);
                        PathMapNode newTarget = new PathMapNode();
                        newTarget.arcs.add(arc);
                        newRoot.createArc(newStep, newTarget);
                        continue block3;
                    }
                    default: {
                        AxisExpression newStep = new AxisExpression(5, arc.getStep().getNodeTest());
                        newRoot.createArc(newStep, arc.getTarget());
                        continue block3;
                    }
                }
            }
            for (i = 0; i < this.pathMapRoots.size(); ++i) {
                if (this.pathMapRoots.get(i) != root) continue;
                this.pathMapRoots.remove(i);
                break;
            }
        }
        Stack<PathMapRoot> nodeStack = new Stack<PathMapRoot>();
        nodeStack.push(newRoot);
        this.reduceToDownwardsAxes(newRoot, nodeStack);
        newRoot.isDownwardsOnly = true;
        return newRoot;
    }

    private void reduceToDownwardsAxes(PathMapRoot root, Stack nodeStack) {
        int i;
        PathMapNode node = (PathMapNode)nodeStack.peek();
        if (node.hasUnknownDependencies()) {
            root.setHasUnknownDependencies();
        }
        for (i = 0; i < node.arcs.size(); ++i) {
            nodeStack.push(((PathMapArc)node.arcs.get(i)).getTarget());
            this.reduceToDownwardsAxes(root, nodeStack);
            nodeStack.pop();
        }
        block9: for (i = node.arcs.size() - 1; i >= 0; --i) {
            Iterator iter;
            PathMapArc thisArc = (PathMapArc)node.arcs.get(i);
            AxisExpression axisStep = thisArc.getStep();
            PathMapNode grandParent = nodeStack.size() < 2 ? null : (PathMapNode)nodeStack.get(nodeStack.size() - 2);
            byte lastAxis = -1;
            if (grandParent != null) {
                iter = grandParent.arcs.iterator();
                while (iter.hasNext()) {
                    PathMapArc arc = (PathMapArc)iter.next();
                    if (arc.getTarget() != node) continue;
                    lastAxis = arc.getStep().getAxis();
                }
            }
            switch (axisStep.getAxis()) {
                case 1: 
                case 5: {
                    if (axisStep.getNodeTest() == NodeKindTest.DOCUMENT) {
                        node.arcs.remove(i);
                        iter = thisArc.getTarget().arcs.iterator();
                        while (iter.hasNext()) {
                            root.arcs.add(iter.next());
                        }
                        continue block9;
                    }
                }
                case 0: 
                case 6: 
                case 10: {
                    if (axisStep.getAxis() == 5) continue block9;
                    AxisExpression newStep = new AxisExpression(5, axisStep.getNodeTest());
                    newStep.setContainer(axisStep.getContainer());
                    root.createArc(newStep, thisArc.getTarget());
                    node.arcs.remove(i);
                    continue block9;
                }
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    continue block9;
                }
                case 7: 
                case 11: {
                    AxisExpression newStep;
                    if (grandParent != null) {
                        newStep = new AxisExpression(lastAxis, axisStep.getNodeTest());
                        newStep.setContainer(axisStep.getContainer());
                        grandParent.createArc(newStep, thisArc.getTarget());
                        node.arcs.remove(i);
                        continue block9;
                    }
                    newStep = new AxisExpression(3, axisStep.getNodeTest());
                    newStep.setContainer(axisStep.getContainer());
                    root.createArc(newStep, thisArc.getTarget());
                    node.arcs.remove(i);
                    continue block9;
                }
                case 9: {
                    AxisExpression newStep;
                    if (lastAxis == 3 || lastAxis == 2 || lastAxis == 8) {
                        if (node.isReturnable()) {
                            grandParent.setReturnable(true);
                        }
                        PathMapNode target = thisArc.getTarget();
                        for (int a2 = 0; a2 < target.arcs.size(); ++a2) {
                            grandParent.arcs.add(target.arcs.get(a2));
                        }
                        node.arcs.remove(i);
                        continue block9;
                    }
                    if (lastAxis == 4) {
                        newStep = new AxisExpression(5, axisStep.getNodeTest());
                        newStep.setContainer(axisStep.getContainer());
                        if (thisArc.getTarget().arcs.isEmpty()) {
                            grandParent.createArc(newStep);
                        } else {
                            grandParent.createArc(newStep, thisArc.getTarget());
                        }
                        node.arcs.remove(i);
                        continue block9;
                    }
                    newStep = new AxisExpression(5, axisStep.getNodeTest());
                    newStep.setContainer(axisStep.getContainer());
                    if (thisArc.getTarget().arcs.isEmpty()) {
                        root.createArc(newStep);
                    } else {
                        root.createArc(newStep, thisArc.getTarget());
                    }
                    node.arcs.remove(i);
                    continue block9;
                }
                case 12: {
                    node.arcs.remove(i);
                }
            }
        }
    }

    public void diagnosticDump(PrintStream out) {
        for (int i = 0; i < this.pathMapRoots.size(); ++i) {
            out.println("\nROOT EXPRESSION " + i);
            PathMapRoot mapRoot = (PathMapRoot)this.pathMapRoots.get(i);
            if (mapRoot.hasUnknownDependencies()) {
                out.println("  -- has unknown dependencies --");
            }
            Expression exp = mapRoot.rootExpression;
            exp.explain(out);
            out.println("\nTREE FOR EXPRESSION " + i);
            this.showArcs(out, mapRoot, 2);
        }
    }

    private void showArcs(PrintStream out, PathMapNode node, int indent) {
        String pad = "                                           ".substring(0, indent);
        List arcs = node.arcs;
        for (int i = 0; i < arcs.size(); ++i) {
            PathMapArc arc = (PathMapArc)arcs.get(i);
            out.println(pad + arc.step + (arc.target.isAtomized() ? " @" : "") + (arc.target.isReturnable() ? " #" : "") + (arc.target.hasUnknownDependencies() ? " ...??" : ""));
            this.showArcs(out, arc.target, indent + 2);
        }
    }

    public static void main(String[] args) throws Exception {
        Expression exp;
        Configuration config = new Configuration();
        if (args[0].equals("xpath")) {
            XPathEvaluator xpath = new XPathEvaluator(config);
            XPathExpression xpexp = xpath.createExpression(args[1]);
            exp = xpexp.getInternalExpression();
        } else if (args[0].equals("xquery")) {
            StaticQueryContext sqc = new StaticQueryContext(config);
            sqc.setBaseURI(new File(args[1]).toURI().toString());
            XQueryExpression xqe = sqc.compileQuery(new FileReader(args[1]));
            exp = xqe.getExpression();
        } else {
            throw new IllegalArgumentException("first argument must be xpath or xquery");
        }
        exp.explain(System.err);
        PathMap initialPath = new PathMap(exp);
        initialPath.diagnosticDump(System.err);
        PathMapRoot[] roots = initialPath.getPathMapRoots();
        for (int i = 0; i < roots.length; ++i) {
            initialPath.reduceToDownwardsAxes(roots[i]);
        }
        System.err.println("AFTER REDUCTION:");
        initialPath.diagnosticDump(System.err);
    }

    public static class PathMapNodeSet
    extends HashSet {
        public PathMapNodeSet() {
        }

        public PathMapNodeSet(PathMapNode singleton) {
            this.add(singleton);
        }

        public PathMapNodeSet createArc(AxisExpression step) {
            PathMapNodeSet targetSet = new PathMapNodeSet();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                PathMapNode node = (PathMapNode)it.next();
                targetSet.add(node.createArc(step));
            }
            return targetSet;
        }

        public void addNodeSet(PathMapNodeSet nodes) {
            if (nodes != null) {
                Iterator it = nodes.iterator();
                while (it.hasNext()) {
                    PathMapNode node = (PathMapNode)it.next();
                    this.add(node);
                }
            }
        }

        public void setAtomized() {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                PathMapNode node = (PathMapNode)it.next();
                node.setAtomized();
            }
        }

        public void addDescendants() {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                PathMapNode node = (PathMapNode)it.next();
                AxisExpression down = new AxisExpression(4, AnyNodeTest.getInstance());
                node.createArc(down);
            }
        }

        public void setHasUnknownDependencies() {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                PathMapNode node = (PathMapNode)it.next();
                node.setHasUnknownDependencies();
            }
        }
    }

    public static class PathMapArc {
        private PathMapNode target;
        private AxisExpression step;

        private PathMapArc(AxisExpression step, PathMapNode target) {
            this.step = step;
            this.target = target;
        }

        public AxisExpression getStep() {
            return this.step;
        }

        public PathMapNode getTarget() {
            return this.target;
        }
    }

    public static class PathMapRoot
    extends PathMapNode {
        private Expression rootExpression;
        private boolean isDownwardsOnly;

        private PathMapRoot(Expression root) {
            this.rootExpression = root;
        }

        public Expression getRootExpression() {
            return this.rootExpression;
        }
    }

    public static class PathMapNode {
        List arcs = new ArrayList();
        private boolean returnable;
        private boolean atomized;
        private boolean hasUnknownDependencies;

        private PathMapNode() {
        }

        public PathMapNode createArc(AxisExpression step) {
            for (int i = 0; i < this.arcs.size(); ++i) {
                PathMapArc a2 = (PathMapArc)this.arcs.get(i);
                if (!a2.getStep().equals(step)) continue;
                return a2.getTarget();
            }
            PathMapNode target = new PathMapNode();
            PathMapArc arc = new PathMapArc(step, target);
            this.arcs.add(arc);
            return target;
        }

        public void createArc(AxisExpression step, PathMapNode target) {
            for (int i = 0; i < this.arcs.size(); ++i) {
                PathMapArc a2 = (PathMapArc)this.arcs.get(i);
                if (!a2.getStep().equals(step) || a2.getTarget() != target) continue;
                a2.getTarget().setReturnable(a2.getTarget().isReturnable() || target.isReturnable());
                if (target.isAtomized()) {
                    a2.getTarget().setAtomized();
                }
                return;
            }
            PathMapArc arc = new PathMapArc(step, target);
            this.arcs.add(arc);
        }

        public PathMapArc[] getArcs() {
            return this.arcs.toArray(new PathMapArc[this.arcs.size()]);
        }

        public void setReturnable(boolean returnable) {
            this.returnable = true;
        }

        public boolean isReturnable() {
            return this.returnable;
        }

        public void setAtomized() {
            this.atomized = true;
        }

        public boolean isAtomized() {
            return this.atomized;
        }

        public void setHasUnknownDependencies() {
            this.hasUnknownDependencies = true;
        }

        public boolean hasUnknownDependencies() {
            return this.hasUnknownDependencies;
        }
    }
}

