/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.LazyExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class LetExpression
extends Assignation
implements TailCallReturner {
    int refCount;
    int evaluationMode = -1;

    public void setIndexedVariable() {
        this.refCount = 10000;
    }

    public boolean isIndexedVariable() {
        return this.refCount == 10000;
    }

    public int getNominalReferenceCount() {
        return this.refCount;
    }

    public void addReference(VariableReference v) {
        ++this.refCount;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.sequence = visitor.typeCheck(this.sequence, contextItemType);
        RoleLocator role = new RoleLocator(3, this.getVariableQName(), 0);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, this.requiredType, role, visitor.getStaticContext());
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType actualItemType = this.sequence.getItemType(th);
        this.refineTypeInformation(actualItemType, this.sequence.getCardinality(), this.sequence instanceof Literal ? ((Literal)this.sequence).getValue() : null, this.sequence.getSpecialProperties(), visitor, this);
        this.action = visitor.typeCheck(this.action, contextItemType);
        return this;
    }

    public boolean implementsStaticTypeCheck() {
        return true;
    }

    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, RoleLocator role, ExpressionVisitor visitor) throws XPathException {
        this.action = TypeChecker.staticTypeCheck(this.action, req, backwardsCompatible, role, visitor);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression act2;
        Expression seq2;
        StaticContext env = visitor.getStaticContext();
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        if (this.action instanceof VariableReference && ((VariableReference)this.action).getBinding() == this) {
            return visitor.optimize(this.sequence, contextItemType);
        }
        if (this.sequence instanceof DocumentInstr && ((DocumentInstr)this.sequence).isTextOnly() && this.allReferencesAreFlattened()) {
            this.sequence = ((DocumentInstr)this.sequence).getStringValueExpression(env);
            this.adoptChildExpression(this.sequence);
        }
        if (!this.isIndexedVariable()) {
            this.refCount = ExpressionTool.getReferenceCount(this.action, this, false);
        }
        if (this.refCount == 0) {
            Expression a2 = visitor.optimize(this.action, contextItemType);
            ExpressionTool.copyLocationInfo(this, a2);
            return a2;
        }
        if (this.refCount == 1 || this.sequence instanceof Literal) {
            this.replaceVariable(opt, this.sequence);
            return visitor.optimize(this.action, contextItemType);
        }
        int tries = 0;
        while (tries++ < 5 && (seq2 = visitor.optimize(this.sequence, contextItemType)) != this.sequence) {
            this.sequence = seq2;
            this.adoptChildExpression(this.sequence);
            visitor.resetStaticProperties();
        }
        tries = 0;
        while (tries++ < 5 && (act2 = visitor.optimize(this.action, contextItemType)) != this.action) {
            this.action = act2;
            this.adoptChildExpression(this.action);
            visitor.resetStaticProperties();
        }
        Expression p = this.promoteWhereClause(null);
        if (p != null) {
            return p;
        }
        this.evaluationMode = this.isIndexedVariable() ? 3 : ExpressionTool.lazyEvaluationMode(this.sequence);
        return this;
    }

    private boolean allReferencesAreFlattened() {
        ArrayList references = new ArrayList();
        ExpressionTool.gatherVariableReferences(this.action, this, references);
        for (int i = references.size() - 1; i >= 0; --i) {
            BindingReference bref = (BindingReference)references.get(i);
            if (bref instanceof VariableReference) {
                VariableReference ref = (VariableReference)bref;
                if (ref.isFlattened()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        this.action.checkPermittedContents(parentType, env, whole);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            ValueRepresentation val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        return let.action.iterate(context);
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            ValueRepresentation val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        return let.action.iterateEvents(context);
    }

    protected ValueRepresentation eval(XPathContext context) throws XPathException {
        if (this.evaluationMode == -1) {
            this.evaluationMode = ExpressionTool.lazyEvaluationMode(this.sequence);
        }
        return ExpressionTool.evaluate(this.sequence, this.evaluationMode, context, this.refCount);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            ValueRepresentation val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        return let.action.evaluateItem(context);
    }

    public void process(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            ValueRepresentation val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        let.action.process(context);
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.action.getItemType(th);
    }

    public int computeCardinality() {
        return this.action.getCardinality();
    }

    public int computeSpecialProperties() {
        int props = this.action.getSpecialProperties();
        int seqProps = this.sequence.getSpecialProperties();
        if ((seqProps & 0x400000) == 0) {
            props &= 0xFFBFFFFF;
        }
        return props;
    }

    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        return ExpressionTool.markTailFunctionCalls(this.action, qName, arity);
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression exp = offer.accept(this);
        if (exp != null) {
            return exp;
        }
        Expression seq2 = this.doPromotion(this.sequence, offer);
        if (seq2 != this.sequence) {
            Binding b2;
            if (seq2 instanceof VariableReference && (b2 = ((VariableReference)seq2).getBinding()) instanceof GlobalVariable) {
                ((GlobalVariable)b2).setReferenceCount(this.refCount < 10 ? 10 : this.refCount);
            }
            this.sequence = seq2;
        }
        if (offer.action == 12 || offer.action == 13 || offer.action == 14 || offer.action == 15) {
            this.action = this.doPromotion(this.action, offer);
        } else if (offer.action == 11 || offer.action == 10) {
            Binding[] savedBindingList = offer.bindingList;
            offer.bindingList = this.extendBindingList(offer.bindingList);
            this.action = this.doPromotion(this.action, offer);
            offer.bindingList = savedBindingList;
        }
        if (this.sequence instanceof VariableReference && !((VariableReference)this.sequence).getBinding().isAssignable()) {
            this.replaceVariable(offer.getOptimizer(), this.sequence);
            return this.action;
        }
        if (this.sequence instanceof LazyExpression && ((LazyExpression)this.sequence).getBaseExpression() instanceof VariableReference && !((VariableReference)((LazyExpression)this.sequence).getBaseExpression()).getBinding().isAssignable()) {
            this.replaceVariable(offer.getOptimizer(), ((LazyExpression)this.sequence).getBaseExpression());
            return this.action;
        }
        return this;
    }

    public Expression copy() {
        LetExpression let = new LetExpression();
        let.setVariableQName(this.variableName);
        let.setRequiredType(this.requiredType);
        let.setSequence(this.sequence.copy());
        Expression newAction = this.action.copy();
        let.setAction(newAction);
        ExpressionTool.rebindVariableReferences(newAction, this, let);
        return let;
    }

    private void replaceVariable(Optimizer opt, Expression seq) throws XPathException {
        Binding newBinding;
        PromotionOffer offer2 = new PromotionOffer(opt);
        offer2.action = 12;
        offer2.bindingList = new Binding[]{this};
        offer2.containingExpression = seq;
        this.action = this.doPromotion(this.action, offer2);
        if (offer2.accepted) {
            offer2.accepted = false;
            this.replaceVariable(opt, seq);
        }
        if (this.isIndexedVariable() && (newBinding = ((VariableReference)seq).getBinding()) instanceof LetExpression) {
            ((LetExpression)newBinding).setIndexedVariable();
        }
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            ValueRepresentation val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        if (let.action instanceof TailCallReturner) {
            return ((TailCallReturner)((Object)let.action)).processLeavingTail(context);
        }
        let.action.process(context);
        return null;
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        LetExpression let = this;
        while (true) {
            ValueRepresentation val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        let.action.evaluatePendingUpdates(context, pul);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("let");
        out.emitAttribute("variable", this.getVariableName());
        out.emitAttribute("as", this.sequence.getItemType(out.getTypeHierarchy()).toString(out.getNamePool()) + Cardinality.getOccurrenceIndicator(this.sequence.getCardinality()));
        if (this.isIndexedVariable()) {
            out.emitAttribute("indexable", "true");
        }
        out.startSubsidiaryElement("be");
        this.sequence.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("return");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

