/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.StringCollator;

public class CollationMap
implements Serializable {
    private Configuration config;
    private String defaultCollationName;
    private HashMap map;

    public CollationMap(Configuration config) {
        this.config = config;
        this.defaultCollationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    public CollationMap(CollationMap in) {
        if (in.map != null) {
            this.map = new HashMap(in.map);
        }
        this.config = in.config;
        this.defaultCollationName = in.defaultCollationName;
    }

    public void setDefaultCollationName(String name) {
        this.defaultCollationName = name;
    }

    public String getDefaultCollationName() {
        return this.defaultCollationName;
    }

    public StringCollator getDefaultCollation() {
        return this.getNamedCollation(this.defaultCollationName);
    }

    public void setNamedCollation(String absoluteURI, StringCollator collator) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(absoluteURI, collator);
    }

    public StringCollator getNamedCollation(String name) {
        StringCollator c2;
        if (name.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        if (this.map != null && (c2 = (StringCollator)this.map.get(name)) != null) {
            return c2;
        }
        return this.config.getCollationURIResolver().resolve(name, null, this.config);
    }
}

