/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class BooleanExpression
extends BinaryExpression
implements Negatable {
    public BooleanExpression(Expression p1, int operator, Expression p2) {
        super(p1, operator, p2);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e2 = super.typeCheck(visitor, contextItemType);
        if (e2 == this) {
            XPathException err0 = TypeChecker.ebvError(this.operand0, visitor.getConfiguration().getTypeHierarchy());
            if (err0 != null) {
                err0.setLocator(this);
                throw err0;
            }
            XPathException err1 = TypeChecker.ebvError(this.operand1, visitor.getConfiguration().getTypeHierarchy());
            if (err1 != null) {
                err1.setLocator(this);
                throw err1;
            }
            if (this.operand0 instanceof Literal && !(((Literal)this.operand0).getValue() instanceof BooleanValue)) {
                this.operand0 = Literal.makeLiteral(BooleanValue.get(this.operand0.effectiveBooleanValue(null)));
            }
            if (this.operand1 instanceof Literal && !(((Literal)this.operand1).getValue() instanceof BooleanValue)) {
                this.operand1 = Literal.makeLiteral(BooleanValue.get(this.operand1.effectiveBooleanValue(null)));
            }
        }
        return e2;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e2 = super.optimize(visitor, contextItemType);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (e2 != this) {
            return e2;
        }
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.operand0 = ExpressionTool.unsortedIfHomogeneous(opt, this.operand0);
        this.operand1 = ExpressionTool.unsortedIfHomogeneous(opt, this.operand1);
        if (this.operator == 10 && (Literal.isConstantBoolean(this.operand0, false) || Literal.isConstantBoolean(this.operand1, false))) {
            return new Literal(BooleanValue.FALSE);
        }
        if (this.operator == 9 && (Literal.isConstantBoolean(this.operand0, true) || Literal.isConstantBoolean(this.operand1, true))) {
            return new Literal(BooleanValue.TRUE);
        }
        if (e2 == this && this.operator == 10 && this.operand1 instanceof UserFunctionCall && th.isSubType(this.operand1.getItemType(th), BuiltInAtomicType.BOOLEAN) && !visitor.isLoopingSubexpression(null)) {
            Expression cond = Choose.makeConditional(this.operand0, this.operand1, Literal.makeLiteral(BooleanValue.FALSE));
            ExpressionTool.copyLocationInfo(this, cond);
            return cond;
        }
        return this;
    }

    public Expression copy() {
        return new BooleanExpression(this.operand0.copy(), this.operator, this.operand1.copy());
    }

    public boolean isNegatable(ExpressionVisitor visitor) {
        return true;
    }

    public Expression negate() {
        if (this.operator == 10) {
            BooleanFn not0 = (BooleanFn)SystemFunction.makeSystemFunction("not", new Expression[]{this.operand0});
            BooleanFn not1 = (BooleanFn)SystemFunction.makeSystemFunction("not", new Expression[]{this.operand1});
            return new BooleanExpression(not0, 9, not1);
        }
        BooleanFn not0 = (BooleanFn)SystemFunction.makeSystemFunction("not", new Expression[]{this.operand0});
        BooleanFn not1 = (BooleanFn)SystemFunction.makeSystemFunction("not", new Expression[]{this.operand1});
        return new BooleanExpression(not0, 10, not1);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext c2) throws XPathException {
        switch (this.operator) {
            case 10: {
                return this.operand0.effectiveBooleanValue(c2) && this.operand1.effectiveBooleanValue(c2);
            }
            case 9: {
                return this.operand0.effectiveBooleanValue(c2) || this.operand1.effectiveBooleanValue(c2);
            }
        }
        throw new UnsupportedOperationException("Unknown operator in boolean expression");
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public static void listAndComponents(Expression exp, List list) {
        if (exp instanceof BooleanExpression && ((BooleanExpression)exp).getOperator() == 10) {
            Iterator iter = exp.iterateSubExpressions();
            while (iter.hasNext()) {
                BooleanExpression.listAndComponents((Expression)iter.next(), list);
            }
        } else {
            list.add(exp);
        }
    }
}

